package com.biz.crm.calculatesalary.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.calculatesalary.model.SfaCalculateSalaryDateEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.calculateSalary.req.SfaCalculateSalaryDateReqVo;
import com.biz.crm.nebular.sfa.calculateSalary.resp.SfaCalculateSalaryDateRespVo;

import java.util.List;

/**
 * 计算薪资日期接口
 *
 * @author lf
 * @date 2020-12-28 15:00:09
 */
public interface ISfaCalculateSalaryDateService extends IService<SfaCalculateSalaryDateEntity> {

    /**
     * 列表
     * @param sfaCalculateSalaryDateReqVo
     * @return PageResult<SfaCalculateSalaryDateRespVo>
     */
    PageResult<SfaCalculateSalaryDateRespVo> findList(SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo);

    /**
     * 查询
     * @param sfaCalculateSalaryDateReqVo
     * @return SfaCalculateSalaryDateRespVo
     */
    SfaCalculateSalaryDateRespVo query(SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo);

    /**
     * 新增
     * @param sfaCalculateSalaryDateReqVo
     * @return
     */
    void save(SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo);

    /**
     * 更新
     * @param sfaCalculateSalaryDateReqVo
     * @return
     */
    void update(SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo);

    /**
     * 删除
     * @param sfaCalculateSalaryDateReqVo
     * @return
     */
    void deleteBatch(SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo);

    /**
     * 启用
     * @param sfaCalculateSalaryDateReqVo
     * @return
     */
    void enableBatch(SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo);

    /**
     * 禁用
     * @param sfaCalculateSalaryDateReqVo
     * @return
     */
    void disableBatch(SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo);

    /**
     * 获取指定年的节假日列表
     * @param year
     * @return
     */
    List<SfaCalculateSalaryDateRespVo> findHoliday(String year);

    /**
     * 获取指定日期的年度节假日列表
     * @param date
     * @return
     */
    List<SfaCalculateSalaryDateRespVo> findHolidayByDate(String date);

    /**
     * 判断指定日期是否节假日(不判断是否有年度信息)
     * @param date
     * @return true
     */
    boolean isHoliday(String date);

    /**
     * 是否计算薪资日期
     * @param date
     * @return true
     */
    boolean isCalculateSalary(String date);
}

