package com.biz.crm.checkin.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.checkin.service.ISfaCheckInSignGroupReportService;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInGroupReqVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInGroupRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 签到组明细生成
 * @author YuanZiJian
 * @date 2021/3/23 14:04
 * @version: V1.0
 */
@Slf4j
@RestController
@RequestMapping("/sfaCheckInSignGroupReport")
@Api(tags = "后台-考勤管理-签到组-签到组签到信息")
public class SfaCheckInSignGroupReportController {
    @Resource
    private ISfaCheckInSignGroupReportService sfaCheckInSignGroupReportService;

    /**
     * 生成当天的签到组签到信息
     */
    @ApiOperation(value = "生成当天的签到组签到信息")
    @PostMapping("/executeTimedTaskReport")
    @CrmLog
    public Result executeTimedTaskReport() {
        sfaCheckInSignGroupReportService.timedTaskReport();
        return Result.ok();
    }
}
