package com.biz.crm.checkin.mapper;

import com.biz.crm.checkin.model.SfaCheckInSignRecordEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInSignRecordRespVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaSignHistoryListReqVo;
import org.apache.ibatis.annotations.Param;
import java.util.List;

/**
 * 签到组-签到记录
 * 
 * @author fily
 * @date 2021-01-05 13:12:38
 */
public interface SfaCheckInSignRecordMapper extends BaseMapper<SfaCheckInSignRecordEntity> {

    /**
     * 列表
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(posCode = "sign_record.pos_code")
    List<SfaCheckInSignRecordRespVo> findSignHistory(Page<SfaCheckInSignRecordRespVo> page,
                                              @Param("reqVo") SfaSignHistoryListReqVo reqVo);
}
