package com.biz.crm.checkin.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 签到组-签到日期;实体类
 *
 * @author 任钢
 * @date 2021-01-04 14:18:34
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_check_in_date")
@CrmTable(name = "sfa_check_in_date", tableNote = "签到组-签到日期")
public class SfaCheckInDateEntity extends CrmExtTenEntity<SfaCheckInDateEntity> {

    /**
     * 签到组编码
     */
    @CrmColumn(name = "group_code",length = 32,note = "签到组编码")
    private String groupCode;

    /**
     * 签到日期
     */
    @CrmColumn(name = "check_in_date",length = 32,note = "签到日期")
    private String checkInDate;

    /**
     * 开始日期
     */
    @CrmColumn(name = "start_time",length = 32,note = "开始日期")
    private String startTime;

    /**
     * 结束日期
     */
    @CrmColumn(name = "end_time",length = 32,note = "结束日期")
    private String endTime;
    /**
     * 时间类型
     */
    @CrmColumn(name = "time_type",length = 10 , note = "时间类型")
    private String timeType;


}
