package com.biz.crm.checkin.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 签到组织;实体类
 *
 * @author 任钢
 * @date 2021-01-04 14:18:34
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_check_in_org")
@CrmTable(name = "sfa_check_in_org", tableNote = "签到组织")
public class SfaCheckInOrgEntity extends CrmExtTenEntity<SfaCheckInOrgEntity> {

    /**
     * 签到组编码
     */
    @CrmColumn(name = "group_code", length = 32, note = "签到组编码")
    private String groupCode;

    /**
     * 组织名称
     */
    @CrmColumn(name = "org_name", length = 128, note = "组织名称")
    private String orgName;

    /**
     * 组织编码
     */
    @CrmColumn(name = "org_code", length = 64, note = "组织编码")
    private String orgCode;

}
