package com.biz.crm.checkin.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 签到人员;实体类
 *
 * @author 任钢
 * @date 2021-01-04 14:18:34
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_check_in_user")
@CrmTable(name = "sfa_check_in_user", tableNote = "签到人员")
public class SfaCheckInUserEntity extends CrmExtTenEntity<SfaCheckInUserEntity> {

    /**
     * 签到组编码
     */
    @CrmColumn(name = "group_code", length = 32, note = "签到组编码")
    private String groupCode;

    /**
     * 用户编码
     */
    @CrmColumn(name = "user_name", length = 128, note = "用户编码")
    private String userName;

    /**
     * 用户名称
     */
    @CrmColumn(name = "real_name", length = 64, note = "用户名称")
    private String realName;

}
