package com.biz.crm.checkin.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.checkin.model.SfaCheckInDateEntity;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInDateReqVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInDateRespVo;

/**
 * 签到组-签到日期;接口
 *
 * @author 任钢
 * @date 2021-01-04 14:18:34
 */
public interface ISfaCheckInDateService extends IService<SfaCheckInDateEntity> {

    /**
     * 列表
     * @param sfaCheckInDateReqVo
     * @return PageResult<SfaCheckInDateRespVo>
     */
    PageResult<SfaCheckInDateRespVo> findList(SfaCheckInDateReqVo sfaCheckInDateReqVo);

    /**
     * 查询
     * @param sfaCheckInDateReqVo
     * @return SfaCheckInDateRespVo
     */
    SfaCheckInDateRespVo query(SfaCheckInDateReqVo sfaCheckInDateReqVo);

    /**
     * 新增
     * @param sfaCheckInDateReqVo
     * @return
     */
    void save(SfaCheckInDateReqVo sfaCheckInDateReqVo);

    /**
     * 更新
     * @param sfaCheckInDateReqVo
     * @return
     */
    void update(SfaCheckInDateReqVo sfaCheckInDateReqVo);

    /**
     * 删除
     * @param sfaCheckInDateReqVo
     * @return
     */
    void deleteBatch(SfaCheckInDateReqVo sfaCheckInDateReqVo);

    /**
     * 启用
     * @param sfaCheckInDateReqVo
     * @return
     */
    void enableBatch(SfaCheckInDateReqVo sfaCheckInDateReqVo);

    /**
     * 禁用
     * @param sfaCheckInDateReqVo
     * @return
     */
    void disableBatch(SfaCheckInDateReqVo sfaCheckInDateReqVo);

    /**
     * 根据签到组编码删除
     * @param groupCode
     */
    void deleteByGroupCode(String groupCode);
}

