package com.biz.crm.checkin.service;

import com.biz.crm.checkin.model.SfaCheckInGroupTypeEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInGroupTypeReqVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInGroupTypeRespVo;

/**
 * 签到组-打卡类型;接口
 *
 * @author 任钢
 * @date 2021-01-04 14:18:34
 */
public interface ISfaCheckInGroupTypeService extends IService<SfaCheckInGroupTypeEntity> {

    /**
     * 列表
     * @param sfaCheckInGroupTypeReqVo
     * @return PageResult<SfaCheckInGroupTypeRespVo>
     */
    PageResult<SfaCheckInGroupTypeRespVo> findList(SfaCheckInGroupTypeReqVo sfaCheckInGroupTypeReqVo);

    /**
     * 查询
     * @param sfaCheckInGroupTypeReqVo
     * @return SfaCheckInGroupTypeRespVo
     */
    SfaCheckInGroupTypeRespVo query(SfaCheckInGroupTypeReqVo sfaCheckInGroupTypeReqVo);

    /**
     * 新增
     * @param sfaCheckInGroupTypeReqVo
     * @return
     */
    void save(SfaCheckInGroupTypeReqVo sfaCheckInGroupTypeReqVo);

    /**
     * 更新
     * @param sfaCheckInGroupTypeReqVo
     * @return
     */
    void update(SfaCheckInGroupTypeReqVo sfaCheckInGroupTypeReqVo);

    /**
     * 删除
     * @param sfaCheckInGroupTypeReqVo
     * @return
     */
    void deleteBatch(SfaCheckInGroupTypeReqVo sfaCheckInGroupTypeReqVo);

    /**
     * 启用
     * @param sfaCheckInGroupTypeReqVo
     * @return
     */
    void enableBatch(SfaCheckInGroupTypeReqVo sfaCheckInGroupTypeReqVo);

    /**
     * 禁用
     * @param sfaCheckInGroupTypeReqVo
     * @return
     */
    void disableBatch(SfaCheckInGroupTypeReqVo sfaCheckInGroupTypeReqVo);

    /**
     * 根据签到组编码删除
     * @param groupCode
     */
    void deleteByGroupCode(String groupCode);
}

