package com.biz.crm.checkin.service;

import com.biz.crm.checkin.model.SfaCheckInSignRecordEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.mdm.PageVo;
import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInSignRecordReqVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInGroupRespVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInSignRecordRespVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaSignHistoryListReqVo;

/**
 * 签到组-签到记录接口
 *
 * @author fily
 * @date 2021-01-05 13:12:38
 */
public interface ISfaCheckInSignRecordService extends IService<SfaCheckInSignRecordEntity> {

    /**
     * 列表
     * @param reqVo
     * @return PageResult<SfaCheckInSignRecordRespVo>
     */
    PageResult<SfaCheckInSignRecordRespVo> findList(SfaSignHistoryListReqVo reqVo);

    /**
     * 查询
     * @param id
     * @return SfaCheckInSignRecordRespVo
     */
    SfaCheckInSignRecordRespVo query(String id);

    /**
     * 我的签到组列表
     * @return
     */
    PageResult<SfaCheckInGroupRespVo> myCheckInGroup(PageVo pageVo);

    /**
     * 自由签到
     * @param reqVo
     */
    void checkInGroupSign(SfaCheckInSignRecordReqVo reqVo);
}

