package com.biz.crm.checkin.service;

import com.biz.crm.checkin.model.SfaCheckInUserEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInUserReqVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInUserRespVo;

/**
 * 签到人员;接口
 *
 * @author 任钢
 * @date 2021-01-04 14:18:34
 */
public interface ISfaCheckInUserService extends IService<SfaCheckInUserEntity> {

    /**
     * 列表
     * @param sfaCheckInUserReqVo
     * @return PageResult<SfaCheckInUserRespVo>
     */
    PageResult<SfaCheckInUserRespVo> findList(SfaCheckInUserReqVo sfaCheckInUserReqVo);

    /**
     * 查询
     * @param sfaCheckInUserReqVo
     * @return SfaCheckInUserRespVo
     */
    SfaCheckInUserRespVo query(SfaCheckInUserReqVo sfaCheckInUserReqVo);

    /**
     * 新增
     * @param sfaCheckInUserReqVo
     * @return
     */
    void save(SfaCheckInUserReqVo sfaCheckInUserReqVo);

    /**
     * 更新
     * @param sfaCheckInUserReqVo
     * @return
     */
    void update(SfaCheckInUserReqVo sfaCheckInUserReqVo);

    /**
     * 删除
     * @param sfaCheckInUserReqVo
     * @return
     */
    void deleteBatch(SfaCheckInUserReqVo sfaCheckInUserReqVo);

    /**
     * 启用
     * @param sfaCheckInUserReqVo
     * @return
     */
    void enableBatch(SfaCheckInUserReqVo sfaCheckInUserReqVo);

    /**
     * 禁用
     * @param sfaCheckInUserReqVo
     * @return
     */
    void disableBatch(SfaCheckInUserReqVo sfaCheckInUserReqVo);

    /**
     * 根据签到组编码删除
     * @param groupCode
     */
    void deleteByGroupCode(String groupCode);
}

