package com.biz.crm.checkin.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInGroupTypeReqVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInGroupTypeRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.checkin.model.SfaCheckInGroupTypeEntity;
import com.biz.crm.checkin.mapper.SfaCheckInGroupTypeMapper;
import com.biz.crm.checkin.service.ISfaCheckInGroupTypeService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * 签到组-打卡类型;接口实现
 *
 * @author 任钢
 * @date 2021-01-04 14:18:34
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaCheckInGroupTypeServiceExpandImpl")
public class SfaCheckInGroupTypeServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaCheckInGroupTypeMapper, SfaCheckInGroupTypeEntity> implements ISfaCheckInGroupTypeService {

    @Resource
    private SfaCheckInGroupTypeMapper sfaCheckInGroupTypeMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaCheckInGroupTypeRespVo> findList(SfaCheckInGroupTypeReqVo reqVo){
        Page<SfaCheckInGroupTypeRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaCheckInGroupTypeRespVo> list = sfaCheckInGroupTypeMapper.findList(page, reqVo);
        return PageResult.<SfaCheckInGroupTypeRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaCheckInGroupTypeRespVo
     */
    @Override
    public SfaCheckInGroupTypeRespVo query(SfaCheckInGroupTypeReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaCheckInGroupTypeReqVo reqVo){
        SfaCheckInGroupTypeEntity entity = CrmBeanUtil.copy(reqVo,SfaCheckInGroupTypeEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaCheckInGroupTypeReqVo reqVo){
        SfaCheckInGroupTypeEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaCheckInGroupTypeReqVo reqVo){
        List<SfaCheckInGroupTypeEntity> sfaCheckInGroupTypeEntities = sfaCheckInGroupTypeMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaCheckInGroupTypeEntities)){
            sfaCheckInGroupTypeEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaCheckInGroupTypeEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaCheckInGroupTypeReqVo reqVo){
        //设置状态为启用
        List<SfaCheckInGroupTypeEntity> sfaCheckInGroupTypeEntities = sfaCheckInGroupTypeMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaCheckInGroupTypeEntities)){
            sfaCheckInGroupTypeEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaCheckInGroupTypeEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaCheckInGroupTypeReqVo reqVo){
        //设置状态为禁用
        List<SfaCheckInGroupTypeEntity> sfaCheckInGroupTypeEntities = sfaCheckInGroupTypeMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaCheckInGroupTypeEntities)){
                sfaCheckInGroupTypeEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaCheckInGroupTypeEntities);
    }

    /**
     * 根据签到组编码删除
     * @param groupCode
     */
    @Override
    public void deleteByGroupCode(String groupCode) {
        sfaCheckInGroupTypeMapper.delete(Wrappers.lambdaQuery(SfaCheckInGroupTypeEntity.class).eq(SfaCheckInGroupTypeEntity::getGroupCode, groupCode));
    }
}
