package com.biz.crm.checkin.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.checkin.model.SfaCheckInDateEntity;
import com.biz.crm.checkin.model.SfaCheckInGroupEntity;
import com.biz.crm.checkin.model.SfaCheckInSignRecordEntity;
import com.biz.crm.checkin.service.ISfaCheckInGroupService;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.eunm.sfa.VisitStepFromEnum;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgWithPositionRespVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInDateRespVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInGroupRespVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInTypeRespVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInUserRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DateUtil;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.checkin.model.SfaCheckInSignGroupReportEntity;
import com.biz.crm.checkin.mapper.SfaCheckInSignGroupReportMapper;
import com.biz.crm.checkin.service.ISfaCheckInSignGroupReportService;
import lombok.extern.slf4j.Slf4j;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 签到组-签到报表接口实现
 *
 * @author fily
 * @date 2021-01-05 13:12:39
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaCheckInSignGroupReportServiceExpandImpl")
public class SfaCheckInSignGroupReportServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaCheckInSignGroupReportMapper, SfaCheckInSignGroupReportEntity> implements ISfaCheckInSignGroupReportService {

    @Resource
    private SfaCheckInSignGroupReportMapper sfaCheckInSignGroupReportMapper;
    @Autowired
    private ISfaCheckInGroupService iSfaCheckInGroupService;
    @Resource
    private MdmOrgFeign mdmOrgFeign;
    @Autowired
    private MdmPositionFeign mdmPositionFeign;

    /**
     * 刷新统计信息
     * @param groupCode 签到组编码
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void refreshReport(String groupCode) {
        // 生成签到记录数据
        SfaCheckInGroupRespVo groupVo = iSfaCheckInGroupService.getByGroupCode(groupCode);
        List<UserInfo> list = new ArrayList<>();
        // 根据组织获取的用户列表
        if(CollectionUtils.isNotEmpty(groupVo.getOrgRespVos())) {
            List<MdmOrgWithPositionRespVo> positionRespVos = ApiResultUtil.objResult(
                    mdmOrgFeign.findOrgWithSinglePositionList(
                            groupVo.getOrgRespVos().stream().map(vo -> vo.getOrgCode()).collect(Collectors.toList())
                    )
            , true);
            positionRespVos.forEach(vo -> {
                if(CollectionUtils.isNotEmpty(vo.getPositionList())){
                    vo.getPositionList().forEach(v -> {
                        if(YesNoEnum.yesNoEnum.ONE.getValue().equals(v.getPrimaryFlag())) {
                            UserInfo user = new UserInfo();
                            user.loding(v.getUserName(), v.getFullName(), v.getPositionCode(), v.getPositionName(),
                                    v.getOrgCode(), v.getOrgName(), v.getParentOrgCode(), v.getParentOrgName());
                            list.add(user);
                        }
                    });
                }
            });
        }
        // 根据用户获取的用户列表
        if(CollectionUtils.isNotEmpty(groupVo.getUserRespVos())) {
            // 设置上级组织信息
            MdmPositionUserOrgReqVo positionUserOrgReqVo = new MdmPositionUserOrgReqVo();
            positionUserOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            positionUserOrgReqVo.setUserNameList(groupVo.getUserRespVos().stream().map(SfaCheckInUserRespVo::getUserName).collect(Collectors.toList()));
            positionUserOrgReqVo.setPrimaryFlag(YesNoEnum.yesNoEnum.ONE.getValue());
            List<MdmPositionUserOrgRespVo> mdmUserList = ApiResultUtil.objResult(mdmPositionFeign.findPositionUserOrgList(positionUserOrgReqVo), true);
            mdmUserList.forEach(v -> {
                UserInfo user = new UserInfo();
                user.loding(v.getUserName(), v.getFullName(), v.getPositionCode(), v.getPositionName(),
                        v.getOrgCode(), v.getOrgName(), v.getParentOrgCode(), v.getParentOrgName());
                list.add(user);
            });
        }
        // 用户去重
        Map<String, UserInfo> userMap = list.stream().collect(Collectors.toMap(UserInfo::getUserName, vo->vo, (k1, k2) -> k2));
        LocalDateTime nowTime = LocalDateTime.now();
        /**
         * 获取当天原来已签到的记录
         */
        List<SfaCheckInSignGroupReportEntity> signList = sfaCheckInSignGroupReportMapper.selectList(
                Wrappers.lambdaQuery(SfaCheckInSignGroupReportEntity.class)
                .eq(SfaCheckInSignGroupReportEntity::getGroupCode, groupVo.getGroupCode())
                .eq(SfaCheckInSignGroupReportEntity::getSignStatus, SfaWorkSignEnum.WorkSignStatus.OK.getVal())
                .eq(SfaCheckInSignGroupReportEntity::getCreateDate,nowTime.format(CrmDateUtils.yyyyMMdd))
        );
        Set<String> signEntitySet = new HashSet<>();
        if(CollectionUtils.isNotEmpty(signList)) {
            signEntitySet = signList.stream().map(
                    entity -> entity.getGroupCode()+entity.getCheckInDateId()+entity.getCheckInTypeId()
            ).collect(Collectors.toSet());
        }

        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DateUtil.DEFAULT_DAY_PATTERN);
        /**
         * 开始生成当天的用户打卡记录
          */
        List<SfaCheckInSignGroupReportEntity> entityList = new ArrayList();
        // 如果是自定义时间——循环日期
        if (VisitStepFromEnum.timeType.DIY_TIME.getValue().equals(groupVo.getTimeType())){
            for(SfaCheckInDateRespVo sfaCheckInDateRespVo: groupVo.getDateRespVos()) {
                // 循环打卡类型
                for(SfaCheckInTypeRespVo sfaCheckInTypeRespVo : groupVo.getTypeRespVos()) {
                    // 循环用户
                    for(String key : userMap.keySet()) {

                        LocalDateTime startTime = LocalDateTime.of(LocalDate.parse(sfaCheckInDateRespVo.getStartTime(), formatter), LocalTime.MIN);
                        LocalDateTime endTime = LocalDateTime.of(LocalDate.parse(sfaCheckInDateRespVo.getEndTime(), formatter), LocalTime.MIN);
                        int compareToStartTime = nowTime.compareTo(startTime);
                        int compareToEndTime = nowTime.compareTo(endTime);
                        //校验生成的时候今天是否在时间段中是就立即执行更新当天的用户打卡记录
                        if(compareToStartTime>=0||compareToEndTime<=0){
                            UserInfo user = userMap.get(key);
                            SfaCheckInSignGroupReportEntity entity = CrmBeanUtil.copy(user, SfaCheckInSignGroupReportEntity.class);
                            entity.setSignStatus(SfaWorkSignEnum.WorkSignStatus.NONE.getVal());
                            entity.setSignStatusName(SfaWorkSignEnum.WorkSignStatus.NONE.getDesc());
                            entity.setSignPlaceExStatus(YesNoEnum.yesNoEnum.NO.getValue());
                            entity.setSignPlaceExStatusName(YesNoEnum.yesNoEnum.NO.getDes());
                            entityList.add(entity);
                            entity.setGroupName(groupVo.getGroupName());
                            entity.setGroupCode(groupVo.getGroupCode());
//                            entity.setCheckInDateId(sfaCheckInDateRespVo.getId());
                            entity.setCheckInDate(nowTime.format(CrmDateUtils.yyyyMMddHHmmss));
                            entity.setCheckInTypeId(sfaCheckInTypeRespVo.getId());
                            entity.setCheckInTypeName(sfaCheckInTypeRespVo.getTypeName());
                            // 判断之前是否有打卡记录
                            if(signEntitySet.contains(entity.getGroupCode()+entity.getCheckInDateId()+entity.getCheckInTypeId())) {
                                entity.setSignStatus(SfaWorkSignEnum.WorkSignStatus.OK.getVal());
                                entity.setSignStatusName(SfaWorkSignEnum.WorkSignStatus.OK.getDesc());
                            }
                        }
                    }
                }
            }
        }else {
                // 如果是长期有效——直接循环打卡类型
                for(SfaCheckInTypeRespVo sfaCheckInTypeRespVo : groupVo.getTypeRespVos()) {
                    // 循环用户
                    for(String key : userMap.keySet()) {
                        //设置今天的打卡报表明细信息
                        UserInfo user = userMap.get(key);
                        SfaCheckInSignGroupReportEntity entity = CrmBeanUtil.copy(user, SfaCheckInSignGroupReportEntity.class);
                        entity.setSignStatus(SfaWorkSignEnum.WorkSignStatus.NONE.getVal());
                        entity.setSignStatusName(SfaWorkSignEnum.WorkSignStatus.NONE.getDesc());
                        entity.setSignPlaceExStatus(YesNoEnum.yesNoEnum.NO.getValue());
                        entity.setSignPlaceExStatusName(YesNoEnum.yesNoEnum.NO.getDes());
                        entityList.add(entity);
                        entity.setGroupName(groupVo.getGroupName());
                        entity.setGroupCode(groupVo.getGroupCode());
//                            entity.setCheckInDateId(sfaCheckInDateRespVo.getId());
                        entity.setCheckInDate(nowTime.format(CrmDateUtils.yyyyMMddHHmmss));
                        entity.setCheckInTypeId(sfaCheckInTypeRespVo.getId());
                        entity.setCheckInTypeName(sfaCheckInTypeRespVo.getTypeName());
                        // 判断之前是否有打卡记录
                        if(signEntitySet.contains(entity.getGroupCode()+entity.getCheckInDateId()+entity.getCheckInTypeId())) {
                            entity.setSignStatus(SfaWorkSignEnum.WorkSignStatus.OK.getVal());
                            entity.setSignStatusName(SfaWorkSignEnum.WorkSignStatus.OK.getDesc());
                        }
                    }
                }
        }
        // 删除当天的原数据
        sfaCheckInSignGroupReportMapper.delete(
                Wrappers.lambdaQuery(SfaCheckInSignGroupReportEntity.class)
                .eq(SfaCheckInSignGroupReportEntity::getGroupCode, groupVo.getGroupCode())
                .eq(SfaCheckInSignGroupReportEntity::getCreateDate,nowTime.format(CrmDateUtils.yyyyMMdd))
        );
        this.saveBatch(entityList);
        // 更新打卡状态
//        sfaCheckInSignGroupReportMapper.updateSignStatus(groupCode, checkInDate, checkInType, userName);
    }
    /**
     * 刷新用户的统计信息
     */
    @Override
    public void refreshReportByUserName(SfaCheckInSignRecordEntity sfaCheckInSignRecordEntity,  YesNoEnum.yesNoEnum yesNoEnum) {
        String groupCode = sfaCheckInSignRecordEntity.getGroupCode()
                , checkInType = sfaCheckInSignRecordEntity.getCheckInTypeId()
                , userName = sfaCheckInSignRecordEntity.getUserName();
        SfaCheckInSignGroupReportEntity entity = sfaCheckInSignGroupReportMapper.selectOne(
                Wrappers.lambdaQuery(SfaCheckInSignGroupReportEntity.class)
                .eq(SfaCheckInSignGroupReportEntity::getSfaCheckInSignRecordId, sfaCheckInSignRecordEntity.getId())
        );
        if(entity == null) {
            SfaCheckInGroupRespVo groupVo = iSfaCheckInGroupService.getByGroupCode(groupCode);
//            SfaCheckInDateRespVo dateRespVo
//            if(VisitStepFromEnum.timeType.DIY_TIME.getValue().equals(groupVo.getTimeType())){
//                SfaCheckInDateRespVo dateRespVo = groupVo.getDateRespVos().stream().filter(vo -> vo.getId().equals(checkInDate))
//                        .collect(Collectors.toList()).get(0);
//            }

            SfaCheckInTypeRespVo typeRespVo = groupVo.getTypeRespVos().stream().filter(vo -> vo.getId().equals(checkInType))
                    .collect(Collectors.toList()).get(0);
            // 设置上级组织信息
            MdmPositionUserOrgReqVo positionUserOrgReqVo = new MdmPositionUserOrgReqVo();
            positionUserOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            positionUserOrgReqVo.setUserName(userName);
            positionUserOrgReqVo.setPrimaryFlag(YesNoEnum.yesNoEnum.ONE.getValue());
            MdmPositionUserOrgRespVo mdmUserVo = ApiResultUtil.objResult(mdmPositionFeign.findPositionUserOrgList(positionUserOrgReqVo), true).get(0);
            UserInfo user = new UserInfo();
            user.loding(mdmUserVo.getUserName(), mdmUserVo.getFullName(), mdmUserVo.getPositionCode(), mdmUserVo.getPositionName(),
                    mdmUserVo.getOrgCode(), mdmUserVo.getOrgName(), mdmUserVo.getParentOrgCode(), mdmUserVo.getParentOrgName());
            entity = CrmBeanUtil.copy(user, SfaCheckInSignGroupReportEntity.class);
            entity.setGroupName(groupVo.getGroupName());
            entity.setGroupCode(groupVo.getGroupCode());
            entity.setCheckInDateId(sfaCheckInSignRecordEntity.getCheckInDateId());
            StringJoiner singDate = new StringJoiner(" ");
            singDate.add(sfaCheckInSignRecordEntity.getSignDate());
            if(StringUtils.isNotBlank(sfaCheckInSignRecordEntity.getSignTime())){
                singDate.add(sfaCheckInSignRecordEntity.getSignTime());
            }
            entity.setCheckInDate(singDate.toString());
            entity.setCheckInTypeId(typeRespVo.getId());
            entity.setCheckInTypeName(typeRespVo.getTypeName());
            entity.setSfaCheckInSignRecordId(sfaCheckInSignRecordEntity.getId());
        }
        entity.setSignStatus(SfaWorkSignEnum.WorkSignStatus.OK.getVal());
        entity.setSignStatusName(SfaWorkSignEnum.WorkSignStatus.OK.getDesc());
        entity.setSignPlaceExStatus(yesNoEnum.getValue());
        entity.setSignPlaceExStatusName(yesNoEnum.getDes());
        this.saveOrUpdate(entity);
    }

    /**
     * 生成当天的签到组明细——用于定时任务
     *
     * @return void
     * @method timedTaskReport
     * @date: 2021/3/1 17:45
     * @author: YuanZiJian
     */
    @Override
    public void timedTaskReport() {
        //找出所有可用的签到组编码
        List<SfaCheckInGroupEntity> groupEntities = iSfaCheckInGroupService.list(Wrappers.lambdaQuery(SfaCheckInGroupEntity.class)
                .eq(SfaCheckInGroupEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode())
                .eq(SfaCheckInGroupEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode()));
        groupEntities.forEach(data->{
            //为每个签到组生成对应当天的report明细
            this.refreshReport(data.getGroupCode());
        });
    }

    /**
     * 用户信息
     */
    @Data
    private class UserInfo {
        // 签到人员帐号
        private String userName;
        // 签到人员名称
        private String realName;
        //人员职位编码
        private String posCode;
        // 人员职位名称
        private String posName;
        // 人员组织编码
        private String orgCode;
        // 人员组织名称
        private String orgName;
        // 人员上级组织编码
        private String parentOrgCode;
        // 人员上级组织名称
        private String parentOrgName;

        public void loding(String userName, String realName, String posCode, String posName, String orgCode,
                           String orgName, String parentOrgCode, String parentOrgName) {
            this.userName = userName;
            this.realName = realName;
            this.posCode = posCode;
            this.posName = posName;
            this.orgCode = orgCode;
            this.orgName = orgName;
            this.parentOrgCode = parentOrgCode;
            this.parentOrgName = parentOrgName;
        }
    }
}
