package com.biz.crm.checkin.service.impl;

import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInSignRecordPictureReqVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInSignRecordPictureRespVo;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.checkin.model.SfaCheckInSignRecordPictureEntity;
import com.biz.crm.checkin.mapper.SfaCheckInSignRecordPictureMapper;
import com.biz.crm.checkin.service.ISfaCheckInSignRecordPictureService;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * 签到组-签到图片接口实现
 *
 * @author fily
 * @date 2021-01-05 13:12:39
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaCheckInSignRecordPictureServiceExpandImpl")
public class SfaCheckInSignRecordPictureServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaCheckInSignRecordPictureMapper, SfaCheckInSignRecordPictureEntity> implements ISfaCheckInSignRecordPictureService {

    @Resource
    private SfaCheckInSignRecordPictureMapper sfaCheckInSignRecordPictureMapper;

    /**
     * 列表
     * @param signRecordId
     * @return
     */
    @Override
    public List<SfaCheckInSignRecordPictureRespVo> findList(String signRecordId){
        SfaCheckInSignRecordPictureReqVo reqVo = new SfaCheckInSignRecordPictureReqVo();
        reqVo.setSignRecordId(signRecordId);
        return sfaCheckInSignRecordPictureMapper.findList(null, reqVo);
    }

}
