package com.biz.crm.checkin.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInTypeReqVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInTypeRespVo;
import com.biz.crm.util.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.checkin.model.SfaCheckInTypeEntity;
import com.biz.crm.checkin.mapper.SfaCheckInTypeMapper;
import com.biz.crm.checkin.service.ISfaCheckInTypeService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * 打卡类型;接口实现
 *
 * @author 任钢
 * @date 2021-01-04 14:18:34
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaCheckInTypeServiceExpandImpl")
public class SfaCheckInTypeServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaCheckInTypeMapper, SfaCheckInTypeEntity> implements ISfaCheckInTypeService {

    @Resource
    private SfaCheckInTypeMapper sfaCheckInTypeMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaCheckInTypeRespVo> findList(SfaCheckInTypeReqVo reqVo){
        Page<SfaCheckInTypeRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaCheckInTypeRespVo> list = sfaCheckInTypeMapper.findList(page, reqVo);
        if(list != null && list.size() > 0 && list.get(0) != null) {
            list.forEach(vo -> {
                vo.setPhotographName(YesNoEnum.yesNoEnum.getYesOrNoDes(vo.getPhotograph()));
                vo.setAppointTimeName(YesNoEnum.yesNoEnum.getYesOrNoDes(vo.getAppointTime()));
            });
        }
        return PageResult.<SfaCheckInTypeRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param id
     * @return sfaCheckInTypeRespVo
     */
    @Override
    public SfaCheckInTypeRespVo query(String id){
        SfaCheckInTypeEntity entity = sfaCheckInTypeMapper.selectOne(Wrappers.lambdaQuery(SfaCheckInTypeEntity.class).eq(SfaCheckInTypeEntity::getId, id));
        if(entity == null) {
            throw new BusinessException("打卡类型id错误");
        }

        SfaCheckInTypeRespVo respVo = CrmBeanUtil.copy(entity, SfaCheckInTypeRespVo.class);
        return respVo;
    }

    /**
     * 新增or编辑
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaCheckInTypeReqVo reqVo){
        SfaCheckInTypeEntity entity = CrmBeanUtil.copy(reqVo,SfaCheckInTypeEntity.class);
        if(StringUtils.isNotEmpty(reqVo.getId())) {
            SfaCheckInTypeEntity old = this.getById(reqVo.getId());
            if(old == null) {
                throw new BusinessException("id错误");
            }
            entity.setId(old.getId());
        }
        this.saveOrUpdate(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaCheckInTypeReqVo reqVo){
        List<SfaCheckInTypeEntity> sfaCheckInTypeEntities = sfaCheckInTypeMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaCheckInTypeEntities)){
            sfaCheckInTypeEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
                 o.setEnableStatus(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaCheckInTypeEntities);
    }
}
