package com.biz.crm.checkin.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInUserReqVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInUserRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.checkin.model.SfaCheckInUserEntity;
import com.biz.crm.checkin.mapper.SfaCheckInUserMapper;
import com.biz.crm.checkin.service.ISfaCheckInUserService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * 签到人员;接口实现
 *
 * @author 任钢
 * @date 2021-01-04 14:18:34
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaCheckInUserServiceExpandImpl")
public class SfaCheckInUserServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaCheckInUserMapper, SfaCheckInUserEntity> implements ISfaCheckInUserService {

    @Resource
    private SfaCheckInUserMapper sfaCheckInUserMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaCheckInUserRespVo> findList(SfaCheckInUserReqVo reqVo){
        Page<SfaCheckInUserRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaCheckInUserRespVo> list = sfaCheckInUserMapper.findList(page, reqVo);
        return PageResult.<SfaCheckInUserRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaCheckInUserRespVo
     */
    @Override
    public SfaCheckInUserRespVo query(SfaCheckInUserReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaCheckInUserReqVo reqVo){
        SfaCheckInUserEntity entity = CrmBeanUtil.copy(reqVo,SfaCheckInUserEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaCheckInUserReqVo reqVo){
        SfaCheckInUserEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaCheckInUserReqVo reqVo){
        List<SfaCheckInUserEntity> sfaCheckInUserEntities = sfaCheckInUserMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaCheckInUserEntities)){
            sfaCheckInUserEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaCheckInUserEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaCheckInUserReqVo reqVo){
        //设置状态为启用
        List<SfaCheckInUserEntity> sfaCheckInUserEntities = sfaCheckInUserMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaCheckInUserEntities)){
            sfaCheckInUserEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaCheckInUserEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaCheckInUserReqVo reqVo){
        //设置状态为禁用
        List<SfaCheckInUserEntity> sfaCheckInUserEntities = sfaCheckInUserMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaCheckInUserEntities)){
                sfaCheckInUserEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaCheckInUserEntities);
    }

    /**
     * 根据签到组编码删除
     * @param groupCode
     */
    @Override
    public void deleteByGroupCode(String groupCode) {
        sfaCheckInUserMapper.delete(Wrappers.lambdaQuery(SfaCheckInUserEntity.class).eq(SfaCheckInUserEntity::getGroupCode, groupCode));
    }
}
