package com.biz.crm.collection.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.collection.service.ISfaDirectoryConfigService;
import com.biz.crm.nebular.sfa.collection.resp.SfaDirectoryConfigRespVo;
import com.biz.crm.nebular.sfa.collection.req.SfaDirectoryConfigReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 拜访步骤表单配置 
 *
 * @author liuhongming
 * @date 2020-09-18 10:33:32
 */
@Slf4j
@RestController
@RequestMapping("/sfaDirectoryConfigController")
@Api(tags = "拜访步骤表单配置 ")
public class SfaDirectoryConfigController {
    @Autowired
    private ISfaDirectoryConfigService sfaDirectoryConfigService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaDirectoryConfigRespVo>> list(@RequestBody SfaDirectoryConfigReqVo sfaDirectoryConfigReqVo) {
        PageResult<SfaDirectoryConfigRespVo> result=sfaDirectoryConfigService.findList(sfaDirectoryConfigReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaDirectoryConfigRespVo> query(@RequestBody SfaDirectoryConfigReqVo sfaDirectoryConfigReqVo) {
        SfaDirectoryConfigRespVo respVo=sfaDirectoryConfigService.query(sfaDirectoryConfigReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaDirectoryConfigReqVo sfaDirectoryConfigReqVo) {
        sfaDirectoryConfigService.save(sfaDirectoryConfigReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaDirectoryConfigReqVo sfaDirectoryConfigReqVo) {
        sfaDirectoryConfigService.update(sfaDirectoryConfigReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaDirectoryConfigReqVo sfaDirectoryConfigReqVo) {
        sfaDirectoryConfigService.deleteBatch(sfaDirectoryConfigReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaDirectoryConfigReqVo sfaDirectoryConfigReqVo) {
        sfaDirectoryConfigService.enableBatch(sfaDirectoryConfigReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaDirectoryConfigReqVo sfaDirectoryConfigReqVo) {
        sfaDirectoryConfigService.disableBatch(sfaDirectoryConfigReqVo);
        return Result.ok("禁用成功");
    }
}
