package com.biz.crm.collection.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.collection.service.ISfaInputConfigService;
import com.biz.crm.nebular.sfa.collection.resp.SfaInputConfigRespVo;
import com.biz.crm.nebular.sfa.collection.req.SfaInputConfigReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 拜访控件 
 *
 * @author liuhongming
 * @date 2020-09-18 10:33:32
 */
@Slf4j
@RestController
@RequestMapping("/sfaInputConfigController")
@Api(tags = "拜访控件 ")
public class SfaInputConfigController {
    @Autowired
    private ISfaInputConfigService sfaInputConfigService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaInputConfigRespVo>> list(@RequestBody SfaInputConfigReqVo sfaInputConfigReqVo) {
        PageResult<SfaInputConfigRespVo> result=sfaInputConfigService.findList(sfaInputConfigReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaInputConfigRespVo> query(@RequestBody SfaInputConfigReqVo sfaInputConfigReqVo) {
        SfaInputConfigRespVo respVo=sfaInputConfigService.query(sfaInputConfigReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaInputConfigReqVo sfaInputConfigReqVo) {
        sfaInputConfigService.save(sfaInputConfigReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaInputConfigReqVo sfaInputConfigReqVo) {
        sfaInputConfigService.update(sfaInputConfigReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaInputConfigReqVo sfaInputConfigReqVo) {
        sfaInputConfigService.deleteBatch(sfaInputConfigReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaInputConfigReqVo sfaInputConfigReqVo) {
        sfaInputConfigService.enableBatch(sfaInputConfigReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaInputConfigReqVo sfaInputConfigReqVo) {
        sfaInputConfigService.disableBatch(sfaInputConfigReqVo);
        return Result.ok("禁用成功");
    }
}
