package com.biz.crm.collection.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.collection.service.ISfaVisitRoleConfigService;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleConfigReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaVisitRoleConfigRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepFromSearchReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepFromToStepSearchReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepFromToStepRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.visitstep.service.ISfaVisitStepFromService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 拜访步骤配置(角色)
 *
 * @author liuhongming
 * @date 2020-09-18 14:49:32
 */
@Slf4j
@RestController
@RequestMapping("/sfaVisitRoleConfigController")
@Api(tags = "拜访步骤配置(角色) ")
public class SfaVisitRoleConfigController {
    @Autowired
    private ISfaVisitRoleConfigService sfaVisitRoleConfigService;

    @Resource
    private ISfaVisitStepFromService sfaVisitStepFromService;


    /**
     * 根据名字模糊查询出
     * 相关下拉拜访步骤表单数据
     */
    @ApiOperation(value = "根据名字模糊查询出相关下拉拜访步骤表单Id+名称")
    @PostMapping("/getStepFromList")
    @CrmLog
    public Result<PageResult<SfaVisitStepFromToStepRespVo>> getStepFromList(@RequestBody SfaVisitStepFromToStepSearchReqVo sfaVisitStepFromToStepSearchReqVo) {
        return Result.ok(sfaVisitStepFromService.queryListToStep(sfaVisitStepFromToStepSearchReqVo));
    }


    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<SfaVisitRoleConfigRespVo>> list(@RequestBody SfaVisitRoleConfigReqVo sfaVisitRoleConfigReqVo) {
        PageResult<SfaVisitRoleConfigRespVo> result=sfaVisitRoleConfigService.findList(sfaVisitRoleConfigReqVo);
        return Result.ok(result);
    }

    /**
     * 通过id查询详情
     */
    @ApiOperation(value = "通过id查询详情")
    @GetMapping("/queryDetailById")
    @CrmLog
    @CrmDictMethod
    public Result<SfaVisitRoleConfigRespVo> queryDetailById(@RequestParam String id) {
        SfaVisitRoleConfigRespVo respVo=sfaVisitRoleConfigService.queryDetailById(id);
        return Result.ok(respVo);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaVisitRoleConfigRespVo> query(@RequestBody SfaVisitRoleConfigReqVo sfaVisitRoleConfigReqVo) {
        SfaVisitRoleConfigRespVo respVo=sfaVisitRoleConfigService.query(sfaVisitRoleConfigReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaVisitRoleConfigReqVo sfaVisitRoleConfigReqVo) {
        sfaVisitRoleConfigService.save(sfaVisitRoleConfigReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaVisitRoleConfigReqVo sfaVisitRoleConfigReqVo) {
        sfaVisitRoleConfigService.update(sfaVisitRoleConfigReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        sfaVisitRoleConfigService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        sfaVisitRoleConfigService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        sfaVisitRoleConfigService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
