package com.biz.crm.collection.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 拜访步骤 -控件目录信息明细 实体类
 *
 * @author liuhongming
 * @date 2020-09-18 10:33:33
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_directory_input")
@CrmTable(name = "sfa_directory_input", tableNote = "拜访步骤 -控件目录信息明细 ")
public class SfaDirectoryInputEntity extends CrmExtTenEntity<SfaDirectoryInputEntity> {

    /**
     * 控件id 控件id
     */
    @CrmColumn(name = "lable_id", length = 32, note = "控件id 控件id")
    private String lableId;

    /**
     * 控件编码 控件编码
     */
    @CrmColumn(name = "lable_code", length = 32, note = "控件编码 控件编码")
    private String lableCode;

    /**
     * 控件名称 控件名称
     */
    @CrmColumn(name = "lable_name", length = 100, note = "控件名称 控件名称")
    private String lableName;

    /**
     * 步骤id 步骤id
     */
    @CrmColumn(name = "directory_id", length = 32, note = "步骤id 步骤id")
    private String directoryId;

    /**
     * 步骤编码 步骤编码
     */
    @CrmColumn(name = "directory_code", length = 32, note = "步骤编码 步骤编码")
    private String directoryCode;

    /**
     * 步骤名称 步骤名称
     */
    @CrmColumn(name = "directory_name", length = 100, note = "步骤名称 步骤名称")
    private String directoryName;

    /**
     * 排列顺序 排列顺序
     */
    @CrmColumn(name = "sort", mysqlType = "int(10)", oracleType = "NUMBER(10,0)", note = "排列顺序 排列顺序")
    private Integer sort;

    /**
     * 是否必填 是否必填(0否 1是	)
     */
    @CrmColumn(name = "is_need", length = 32, note = "是否必填 是否必填(0否 1是)")
    private String isNeed;

}
