package com.biz.crm.collection.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 拜访控件 实体类
 *
 * @author liuhongming
 * @date 2020-09-18 10:33:32
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_input_config")
@CrmTable(name = "sfa_input_config", tableNote = "拜访控件")
public class SfaInputConfigEntity extends CrmExtTenEntity<SfaInputConfigEntity> {

    /**
     * 控件编码 控件编码
     */
    @CrmColumn(name = "lable_code", length = 32, note = "控件编码")
    private String lableCode;

    /**
     * 控件名称 控件名称
     */
    @CrmColumn(name = "lable_name", length = 100, note = "控件名称")
    private String lableName;

    /**
     * 控件类型 控件类型
     */
    @CrmColumn(name = "input_type", length = 32, note = "控件类型")
    private String inputType;

    /**
     * 值对应数据字典编码 值对应数据字典编码
     */
    @CrmColumn(name = "dictionary_code", length = 32, note = "值对应数据字典编码")
    private String dictionaryCode;

    /**
     * 高度 高度
     */
    @CrmColumn(name = "height", mysqlType = "int(10)", oracleType = "NUMBER(10,0)", note = "高度")
    private Integer height;

    /**
     * 宽度 宽度
     */
    @CrmColumn(name = "width", mysqlType = "int(10)", oracleType = "NUMBER(10,0)", note = "宽度")
    private Integer width;

}
