package com.biz.crm.collection.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 拜访步骤配置(角色)--拜访步骤表单配置 实体类
 *
 * @author liuhongming
 * @date 2020-09-18 14:49:32
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_visit_role_directory")
@CrmTable(name = "sfa_visit_role_directory", tableNote = "拜访步骤配置(角色)--拜访步骤表单配置 ",indexes = {
        @Index(name = "SFA_VISIT_ROLE_DIRECTORY_INDEX1",columnList = "VISIT_ROLE_CODE")
})
public class SfaVisitRoleDirectoryEntity extends CrmExtTenEntity<SfaVisitRoleDirectoryEntity> {

    /**
     * 步骤id 步骤id
     */
    @CrmColumn(name = "directory_id", length = 32, note = "步骤id")
    private String directoryId;

    /**
     * 步骤编码 步骤编码
     */
    @CrmColumn(name = "directory_code", length = 32, note = "步骤编码")
    private String directoryCode;

    /**
     * 步骤名称 步骤名称
     */
    @CrmColumn(name = "directory_name", length = 100, note = "步骤名称")
    private String directoryName;

    /**
     * 排列顺序 排列顺序
     */
    @CrmColumn(name = "sort", mysqlType = "int(10)", oracleType = "NUMBER(10,0)", note = "排列顺序")
    private Integer sort;

    /**
     * 是否必做 是否必做
     */
    @CrmColumn(name = "do_not", length = 5, note = "是否必做")
    private String doNot;

    /**
     * 拜访步骤配置(角色)编码
     */
    @CrmColumn(name = "visit_role_code", length = 32, note = "拜访步骤配置(角色)编码")
    private String visitRoleCode;

}
