package com.biz.crm.collection.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.collection.controller.resp.VisitStepResp;
import com.biz.crm.collection.model.SfaVisitRoleDirectoryEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitResp;
import com.biz.crm.nebular.sfa.collection.req.FindVisitDetailReqVo;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleConfigReqVo;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleDirectoryReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaVisitRoleDirectoryRespVo;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;

import java.util.List;
import java.util.Map;

/**
 * 拜访步骤配置(角色)--拜访步骤表单配置 接口
 *
 * @author liuhongming
 * @date 2020-09-18 14:49:32
 */
public interface ISfaVisitRoleDirectoryService extends IService<SfaVisitRoleDirectoryEntity> {

    /**
     * 列表
     * @param sfaVisitRoleDirectoryReqVo
     * @return PageResult<SfaVisitRoleDirectoryRespVo>
     */
    PageResult<SfaVisitRoleDirectoryRespVo> findList(SfaVisitRoleDirectoryReqVo sfaVisitRoleDirectoryReqVo);

    /**
     * 通过角色编码查询当前拜访步骤
     * @param reqVo
     * @return
     */
    List<SfaVisitRoleDirectoryRespVo> findRoleDirectoryList(SfaVisitRoleConfigReqVo reqVo);

    /**
     * 查询拜访步骤
     * @return
     */
    List<SfaVisitRoleDirectoryRespVo> findVisitRoleDirectoryList(String redisHashKey, String visitBigType);

    List<VisitStepResp> findVisitRoleDirectoryList(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity);

    /**
     * 查询拜访详情
     * @param reqVo
     * @return
     */
    List<SfaVisitRoleDirectoryRespVo> findVisitDetail(FindVisitDetailReqVo reqVo);

    /**
     * 查询
     * @param sfaVisitRoleDirectoryReqVo
     * @return SfaVisitRoleDirectoryRespVo
     */
    SfaVisitRoleDirectoryRespVo query(SfaVisitRoleDirectoryReqVo sfaVisitRoleDirectoryReqVo);

    /**
     * 查询该拜访/协访计划的步骤列表
     * @param sfaVisitPlanInfoEntity
     * @return
     */
    Map<String, VisitStepResp> findRoleVisitStepMap(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity);

    /**
     * 查询该拜访/协访计划的步骤列表
     * @return
     */
    Map<String, VisitStepResp> findRoleVisitStepMap(SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey, String clientSubclass);

    /**
     * 组装拜访计划明细的进离店表单id
     * @param visitPlanInfo
     * @param visitPosCode
     */
    void buildSfaVisitPlanInfoFormId(SfaVisitResp.SfaVisitPlanInfoResp visitPlanInfo, String visitPosCode);
    /**
     * 查询职位客户类型下的步骤列表
     * @param visitPosCode
     * @param clientTypes
     * @return
     */
    Map<String, Map<String, VisitStepResp>> findRoleVisitStepMapForClientTypes(String visitUserName, String visitPosCode, List<String> clientTypes, String visitBigType, List<String> clientSubclassList);

    /**
     * 新增
     * @param sfaVisitRoleDirectoryReqVo
     * @return
     */
    void save(SfaVisitRoleDirectoryReqVo sfaVisitRoleDirectoryReqVo);

    /**
     * 更新
     * @param sfaVisitRoleDirectoryReqVo
     * @return
     */
    void update(SfaVisitRoleDirectoryReqVo sfaVisitRoleDirectoryReqVo);

    /**
     * 删除
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);

    /**
     * 查询角色拜访步骤是否离线
     * @param sfaVisitPlanInfoEntity
     * @return
     */
    String findRoleStepIsOffLine(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity);
}

