package com.biz.crm.collection.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.collection.mapper.SfaDirectoryInputMapper;
import com.biz.crm.collection.model.SfaDirectoryInputEntity;
import com.biz.crm.collection.service.ISfaDirectoryInputService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.collection.req.SfaDirectoryInputReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaDirectoryInputRespVo;
import com.biz.crm.util.CrmBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 拜访步骤 -控件目录信息明细 接口实现
 *
 * @author liuhongming
 * @date 2020-09-18 10:33:33
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaDirectoryInputServiceExpandImpl")
public class SfaDirectoryInputServiceImpl extends ServiceImpl<SfaDirectoryInputMapper, SfaDirectoryInputEntity> implements ISfaDirectoryInputService {

    @Resource
    private SfaDirectoryInputMapper sfaDirectoryInputMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    @CrmLog
    public PageResult<SfaDirectoryInputRespVo> findList(SfaDirectoryInputReqVo reqVo){
        Page<SfaDirectoryInputRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaDirectoryInputRespVo> list = sfaDirectoryInputMapper.findList(page, reqVo);
        return PageResult.<SfaDirectoryInputRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaDirectoryInputRespVo
     */
    @Override
    @CrmLog
    public SfaDirectoryInputRespVo query(SfaDirectoryInputReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void save(SfaDirectoryInputReqVo reqVo){
        SfaDirectoryInputEntity entity = CrmBeanUtil.copy(reqVo,SfaDirectoryInputEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void update(SfaDirectoryInputReqVo reqVo){
        SfaDirectoryInputEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void deleteBatch(SfaDirectoryInputReqVo reqVo){
        List<SfaDirectoryInputEntity> sfaDirectoryInputEntities = sfaDirectoryInputMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaDirectoryInputEntities)){
            sfaDirectoryInputEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaDirectoryInputEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void enableBatch(SfaDirectoryInputReqVo reqVo){
        //设置状态为启用
        List<SfaDirectoryInputEntity> sfaDirectoryInputEntities = sfaDirectoryInputMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaDirectoryInputEntities)){
            sfaDirectoryInputEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaDirectoryInputEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void disableBatch(SfaDirectoryInputReqVo reqVo){
        //设置状态为禁用
        List<SfaDirectoryInputEntity> sfaDirectoryInputEntities = sfaDirectoryInputMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaDirectoryInputEntities)){
                sfaDirectoryInputEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaDirectoryInputEntities);
    }
}
