package com.biz.crm.collection.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.collection.mapper.SfaVisitRoleConfigMapper;
import com.biz.crm.collection.mapper.SfaVisitRoleDirectoryMapper;
import com.biz.crm.collection.model.SfaVisitRoleConfigEntity;
import com.biz.crm.collection.model.SfaVisitRoleDirectoryEntity;
import com.biz.crm.collection.service.ISfaVisitRoleConfigService;
import com.biz.crm.collection.service.ISfaVisitRoleDirectoryService;
import com.biz.crm.common.PageResult;
import com.biz.crm.common.param.ParameterParam;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleConfigReqVo;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleDirectoryReqVo;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaVisitRoleConfigRespVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaVisitRoleDirectoryRespVo;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 拜访步骤配置(角色) 接口实现
 *
 * @author liuhongming
 * @date 2020-09-18 14:49:32
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaVisitRoleConfigServiceExpandImpl")
@Transactional
public class SfaVisitRoleConfigServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaVisitRoleConfigMapper, SfaVisitRoleConfigEntity> implements ISfaVisitRoleConfigService {

    @Resource
    private SfaVisitRoleConfigMapper sfaVisitRoleConfigMapper;
    @Resource
    private SfaVisitRoleDirectoryMapper sfaVisitRoleDirectoryMapper;

    @Autowired
    private ISfaVisitRoleDirectoryService iSfaVisitRoleDirectoryService;


    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaVisitRoleConfigRespVo> findList(SfaVisitRoleConfigReqVo reqVo){
        Page<SfaVisitRoleConfigRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaVisitRoleConfigRespVo> list = sfaVisitRoleConfigMapper.findList(page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)){
            List<String> visitRoleCodes = list.stream().map(SfaVisitRoleConfigRespVo:: getVisitRoleCode).collect(Collectors.toList());
            SfaVisitRoleDirectoryReqVo visitRoleDirectoryReqVo = new SfaVisitRoleDirectoryReqVo();
            visitRoleDirectoryReqVo.setVisitRoleCodes(visitRoleCodes);
            visitRoleDirectoryReqVo.setPageSize(-1);
            List<SfaVisitRoleDirectoryRespVo> visitRoleDirectoryRespVos = iSfaVisitRoleDirectoryService.findList(visitRoleDirectoryReqVo).getData();
            Map<String, List<SfaVisitRoleDirectoryRespVo>> visitRoleDirectoryRespMap = visitRoleDirectoryRespVos.stream()
                    .collect(Collectors.groupingBy(SfaVisitRoleDirectoryRespVo :: getVisitRoleCode));
            for (SfaVisitRoleConfigRespVo visitRoleConfigRespVo:list) {
                List<SfaVisitRoleDirectoryRespVo> voList = visitRoleDirectoryRespMap.get(visitRoleConfigRespVo.getVisitRoleCode());
                if (voList != null && voList.size() > 0) {
                    StringBuffer buffer = new StringBuffer();
                    for (SfaVisitRoleDirectoryRespVo roleDirectoryRespVo:voList){
                        if (buffer.length()>0){
                            buffer.append("、");
                        }
                        buffer.append(roleDirectoryRespVo.getDirectoryName());
                    }
                    visitRoleConfigRespVo.setDirectoryDescs(buffer.toString());
                }
//                visitRoleConfigRespVo.setSfacusTypeDesc(SfaVisitRoleEnum.getSfaVisitRole(visitRoleConfigRespVo.getSfacusType()).getDesc());
//                visitRoleConfigRespVo.setVisitTypeDesc(SfaVisitRoleEnum.getSfaVisitRole(visitRoleConfigRespVo.getVisitType()).getDesc());
                visitRoleConfigRespVo.setEnableStatusName(CrmEnableStatusEnum.getDesc(visitRoleConfigRespVo.getEnableStatus()));
            }
        }

        return PageResult.<SfaVisitRoleConfigRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }
    /**
     * 通过id查询详情
     * @param id
     * @return
     */
    @Override
    public SfaVisitRoleConfigRespVo queryDetailById(String id) {
        AssertUtils.isNotEmpty(id,"数据主键不能为空");
        SfaVisitRoleConfigEntity entity = this.getById(id);
        if(null == entity){
            throw new BusinessException("未查询到拜访步骤配置信息");
        }
        SfaVisitRoleConfigRespVo respVo = CrmBeanUtil.copy(entity, SfaVisitRoleConfigRespVo.class);
        //查询拜访步骤表单配置明细
        SfaVisitRoleDirectoryReqVo visitRoleDirectoryReqVo = new SfaVisitRoleDirectoryReqVo();
        visitRoleDirectoryReqVo.setVisitRoleCode(respVo.getVisitRoleCode());
        List<SfaVisitRoleDirectoryRespVo> visitRoleDirectoryRespVos =
                iSfaVisitRoleDirectoryService.findList(visitRoleDirectoryReqVo).getData();
        respVo.setVisitRoleDirectoryRespVos(visitRoleDirectoryRespVos);
        return respVo;
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaVisitRoleConfigRespVo
     */
    @Override
    public SfaVisitRoleConfigRespVo query(SfaVisitRoleConfigReqVo reqVo){
        if (null==reqVo||(StringUtils.isEmpty(reqVo.getId())&& CollectionUtil.listEmpty(reqVo.getIds()))){
            return new SfaVisitRoleConfigRespVo();
        }
        List<SfaVisitRoleConfigRespVo> list = this.findList(reqVo).getData();
        if (CollectionUtil.listEmpty(list)){
            return new SfaVisitRoleConfigRespVo();
        }
        SfaVisitRoleConfigRespVo respVo = list.get(0);
        //查询拜访步骤表单配置明细
        SfaVisitRoleDirectoryReqVo visitRoleDirectoryReqVo = new SfaVisitRoleDirectoryReqVo();
        visitRoleDirectoryReqVo.setVisitRoleCode(respVo.getVisitRoleCode());
        List<SfaVisitRoleDirectoryRespVo> visitRoleDirectoryRespVos =
                iSfaVisitRoleDirectoryService.findList(visitRoleDirectoryReqVo).getData();
        respVo.setVisitRoleDirectoryRespVos(visitRoleDirectoryRespVos);
        return respVo;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    public void save(SfaVisitRoleConfigReqVo reqVo){
        this.saveCheck(reqVo);
        List<SfaVisitRoleDirectoryEntity> directoryEntities = Lists.newArrayList();
        List<SfaVisitRoleConfigEntity> configEntities = Lists.newArrayList();
        for (SfaVisitRoleReqVo visitRoleReqVo:reqVo.getVisitRoleReqVos()){
            SfaVisitRoleConfigEntity entity = CrmBeanUtil.copy(reqVo,SfaVisitRoleConfigEntity.class);
            String code = CodeUtil.getCodeDefault();
            entity.setVisitRoleCode(code);
            entity.setRoleCode(visitRoleReqVo.getRoleCode());
            entity.setRoleName(visitRoleReqVo.getRoleName());
            entity.setId(UUIDGenerator.generate());
            configEntities.add(entity);
            directoryEntities.addAll(this.buildDirectoryList(reqVo.getVisitRoleDirectoryReqVos(),entity));
        }
        if(configEntities.size() > 0){
            this.saveBatch(configEntities);
        }
        if(directoryEntities.size() > 0){
            iSfaVisitRoleDirectoryService.saveBatch(directoryEntities);
        }
    }

    protected void saveCheck(SfaVisitRoleConfigReqVo reqVo){

        AssertUtils.isNotEmpty(reqVo.getVisitType(),"请选择拜访类型");
        AssertUtils.isNotEmpty(reqVo.getIsOffLine(),"是否离线操作请选择");
        if(!SfaVisitEnum.VisitBigType.UNFAMILIAR_VISIT.getVal().equals(reqVo.getVisitType())){
            String configRange = ParamUtil.getParameterValue(ParameterParam.SFA_VISIT_STEP_CONFIG_CLIENT_SUBCLASS_RANGE);
            if(YesNoEnum.yesNoEnum.NO.getValue().equals(configRange)){
                reqVo.setClientSubclass("");
                reqVo.setClientSubclassName("");
            }else{
                AssertUtils.isNotEmpty(reqVo.getSfacusType(),"请选择客户类型");
                AssertUtils.isNotEmpty(reqVo.getClientSubclass(),"请选择客户客户细类");
            }
        }else{
            reqVo.setSfacusType("");
            reqVo.setSfacusTypeName("");
            reqVo.setClientSubclass("");
            reqVo.setClientSubclassName("");
        }
        this.saveCheckRole(reqVo);
        this.saveCheckRoleDirectory(reqVo);

    }

    protected void saveCheckRoleDirectory(SfaVisitRoleConfigReqVo reqVo){
        List<SfaVisitRoleDirectoryReqVo> visitRoleDirectoryReqVos = reqVo.getVisitRoleDirectoryReqVos();
        if (CollectionUtil.listEmpty(visitRoleDirectoryReqVos)){
            throw new BusinessException("请选择对应拜访步骤.");
        }
        Set<String> directorCode = visitRoleDirectoryReqVos.stream().map(SfaVisitRoleDirectoryReqVo::getDirectoryCode).collect(Collectors.toSet());
        //步骤不能重复——比原来小就说明有重复
        if (directorCode.size()<reqVo.getVisitRoleDirectoryReqVos().size()){
            HashMap<String,String> hashMap = new HashMap();
            StringJoiner stringJoiner = new StringJoiner(",");
            reqVo.getVisitRoleDirectoryReqVos().forEach(data->{
                if(hashMap.containsKey(data.getDirectoryCode())){
                    stringJoiner.add(data.getDirectoryName());
                }else {
                    hashMap.put(data.getDirectoryCode(),data.getDirectoryName());
                }
            });
            throw new BusinessException("选择的拜访步骤中存在重复步骤："+stringJoiner.toString());
        }
        Map<String,String> map = new HashMap<>();
        reqVo.getVisitRoleDirectoryReqVos().stream().forEach(data->{
            if (!StringUtils.isNotEmpty(data.getSort().toString())){
                throw new BusinessException("步骤:"+data.getDirectoryName()+"排序为空");
            }
            if (map.containsKey(data.getSort())){
                throw new BusinessException("步骤排序重复:"+data.getDirectoryName());
            }
        });
    }

    protected void saveCheckRole(SfaVisitRoleConfigReqVo reqVo){
        List<SfaVisitRoleReqVo> visitRoleReqVos = reqVo.getVisitRoleReqVos();
        if (CollectionUtil.listEmpty(visitRoleReqVos)){
            throw new BusinessException("请选择对应角色.");
        }
        List<String> roleCodes = visitRoleReqVos.stream()
                .map(v -> {
                    if(org.apache.commons.lang3.StringUtils.isBlank(v.getRoleCode())){
                        throw new BusinessException("提交了空值角色编码");
                    }
                    return v.getRoleCode();
                }).collect(Collectors.toList());

        LambdaQueryWrapper<SfaVisitRoleConfigEntity> wrapper =
                new LambdaQueryWrapper<SfaVisitRoleConfigEntity>()
                        .in(SfaVisitRoleConfigEntity::getRoleCode, roleCodes)
                        .eq(SfaVisitRoleConfigEntity::getVisitType,reqVo.getVisitType());
        if(!SfaVisitEnum.VisitBigType.UNFAMILIAR_VISIT.getVal().equals(reqVo.getVisitType())){
            wrapper.eq(SfaVisitRoleConfigEntity::getSfacusType,reqVo.getSfacusType())
                    .eq(SfaVisitRoleConfigEntity::getClientSubclass,reqVo.getClientSubclass());
        }
        Map<String, SfaVisitRoleConfigEntity> roleMapConfig = sfaVisitRoleConfigMapper.selectList(wrapper).stream()
                .collect(Collectors.toMap(SfaVisitRoleConfigEntity :: getRoleCode, v -> v, (t, t2) -> t2));

        for (SfaVisitRoleReqVo visitRoleReqVo : visitRoleReqVos){
            if (roleMapConfig.containsKey(visitRoleReqVo.getRoleCode())){
                throw new BusinessException("角色["+ visitRoleReqVo.getRoleName() +"]已存在[" + SfaVisitEnum.VisitBigType.GETMAP.get(reqVo.getVisitType()) + "]步骤配置,不能重复配置");
            }
        }
    }

    /**
     * 保存业务明细数据
     * @param visitRoleDirectoryReqVos
     * @param entity
     */
    public List<SfaVisitRoleDirectoryEntity> buildDirectoryList(List<SfaVisitRoleDirectoryReqVo> visitRoleDirectoryReqVos, SfaVisitRoleConfigEntity entity){
        if (CollectionUtil.listNotEmptyNotSizeZero(visitRoleDirectoryReqVos)){
            List<SfaVisitRoleDirectoryEntity> visitRoleDirectoryEntityList = visitRoleDirectoryReqVos.stream().map(o -> {
                SfaVisitRoleDirectoryEntity visitRoleDirectoryEntity = new SfaVisitRoleDirectoryEntity();
                AssertUtils.isNotEmpty(o.getDoNot(),o.getDirectoryName()+"步骤未选择是否必做！");
                CrmBeanUtil.copyProperties(o, visitRoleDirectoryEntity);
                visitRoleDirectoryEntity.setVisitRoleCode(entity.getVisitRoleCode());
                return visitRoleDirectoryEntity;
            }).collect(Collectors.toList());
            return visitRoleDirectoryEntityList;

        }
        return Lists.newArrayList();
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional
    public void update(SfaVisitRoleConfigReqVo reqVo){

        this.saveCheckRoleDirectory(reqVo);

        if(StringUtils.isEmpty(reqVo.getId())){
            throw new BusinessException("数据主键不能为空");
        }
        SfaVisitRoleConfigEntity entity = this.getById(reqVo.getId());
        if(Objects.isNull(entity)){
            throw new BusinessException("拜访步骤数据不存在");
        }
        entity.setIsOffLine(reqVo.getIsOffLine());
        this.updateById(entity);
        if (CollectionUtil.listEmpty(reqVo.getVisitRoleDirectoryReqVos())){
            throw new BusinessException("请选择对应拜访步骤.");
        }

        iSfaVisitRoleDirectoryService.remove(Wrappers.lambdaQuery(SfaVisitRoleDirectoryEntity.class)
                .eq(SfaVisitRoleDirectoryEntity::getVisitRoleCode,entity.getVisitRoleCode()));
        List<SfaVisitRoleDirectoryEntity> directoryEntities = this.buildDirectoryList(reqVo.getVisitRoleDirectoryReqVos(),entity);
        if(directoryEntities.size() > 0){
            iSfaVisitRoleDirectoryService.saveBatch(directoryEntities);
        }
    }

    /**
     * 删除
     * @param ids
     * @return
     */
    @Override
    public void deleteBatch(List<String> ids){
        SfaVisitRoleConfigReqVo reqVo = new SfaVisitRoleConfigReqVo();
        if(!CollectionUtil.listNotEmptyNotSizeZero(ids)){
            throw new BusinessException("数据主键不能为空");
        }
        reqVo.setIds(ids);
        reqVo.setPageSize(-1);
        List<SfaVisitRoleConfigRespVo> list = this.findList(reqVo).getData();
        if (CollectionUtil.listEmpty(list)){
            throw new BusinessException("拜访步骤数据不存在");
        }
        sfaVisitRoleConfigMapper.deleteProductsByParams(reqVo);
        List<String> visitRoleCodes = list.stream().map(SfaVisitRoleConfigRespVo :: getVisitRoleCode).collect(Collectors.toList());
        reqVo.setVisitRoleCodes(visitRoleCodes);
        this.deleteBatchDate(reqVo);
    }

    public void deleteBatchDate(SfaVisitRoleConfigReqVo reqVo){
        if(StringUtils.isEmpty(reqVo.getVisitRoleCode())&&CollectionUtil.listEmpty(reqVo.getVisitRoleCodes())){
            throw new BusinessException("数据主键不能为空");
        }
        SfaVisitRoleDirectoryReqVo visitRoleDirectoryReqVo = new SfaVisitRoleDirectoryReqVo();
        visitRoleDirectoryReqVo.setVisitRoleCode(reqVo.getVisitRoleCode());
        visitRoleDirectoryReqVo.setVisitRoleCodes(reqVo.getVisitRoleCodes());
        sfaVisitRoleDirectoryMapper.deleteProductsByParams(visitRoleDirectoryReqVo);
    }

    /**
     * 启用
     * @param ids
     * @return
     */
    @Override
    public void enableBatch(List<String> ids){
        if(!CollectionUtil.listNotEmptyNotSizeZero(ids)){
            throw new BusinessException("数据主键不能为空");
        }
        //设置状态为启用
        List<SfaVisitRoleConfigEntity> sfaVisitRoleConfigEntities = sfaVisitRoleConfigMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(sfaVisitRoleConfigEntities)){
            sfaVisitRoleConfigEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitRoleConfigEntities);
    }

    /**
     * 禁用
     * @param ids
     * @return
     */
    @Override
    public void disableBatch(List<String> ids){
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)){
            throw new BusinessException("数据主键不能为空");
        }
        //设置状态为禁用
        List<SfaVisitRoleConfigEntity> sfaVisitRoleConfigEntities = sfaVisitRoleConfigMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(sfaVisitRoleConfigEntities)){
                sfaVisitRoleConfigEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitRoleConfigEntities);
    }
}
