package com.biz.crm.customer.controller;


import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.sfa.customer.req.SfaCustomerBusinessDetailReqVo;
import com.biz.crm.util.*;
import lombok.extern.slf4j.Slf4j;

import java.util.List;
import java.util.Map;

/**
 * 业务动态保存
 * @author yangshan
 * @date 2021/4/10 15:40
 */
@Slf4j
public class SfaBusinessDetailSaveMQSend {

    private static RocketMQProducer rocketMQProducer = SpringApplicationContextUtil.getApplicationContext().getBean(RocketMQProducer.class);

    public static void saveBusinessDetail(List<? extends VisitStepListener.VisitStepListenerCommittedData> entities){
        List<SfaCustomerBusinessDetailReqVo> reqVos = CrmBeanUtil.copyList(entities, SfaCustomerBusinessDetailReqVo.class);
        //stepCode数据字典Map
        Map<String, String> stringStringMap = DictUtil.dictMap(SfaVisitEnum.SfaStepCode.DICT_CODE);
        //创建人信息
        reqVos.forEach(o -> {
            o.setBusinessCode(o.getId());
            o.setBusinessType(stringStringMap.get(o.getStepCode()));
        });

        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTag(RocketMQConstant.CRM_MQ_TAG.CUSTOMER_BUSINESS_DETAIL_TAG);
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonStringNotEmptyVal(reqVos));
        rocketMQMessageBody.setToken(UserUtils.getToken());
        rocketMQProducer.convertAndSend(rocketMQMessageBody);
    }
}
