package com.biz.crm.customer.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;

import javax.persistence.Index;

/**
 * 客户信息业务动态
 *
 * @author yangshan
 * @date 2021-3-4 10:12:53
 */
@Data
@TableName("sfa_business_detail")
@CrmTable(name = "sfa_business_detail", tableNote = "客户业务动态信息" , indexes = {
        @Index(name = "sfa_business_detail_index1",columnList = ("business_code , step_code"),unique = true)
})
public class SfaCustomerBusinessDetailEntity extends CrmExtTenEntity<SfaCustomerBusinessDetailEntity> {

    /**
     * 客户编码
     */
    @CrmColumn(name = "client_code", length = 100,note = "客户编码")
    private String clientCode;

    /**
     * 业务类型
     */
    @CrmColumn(name = "business_type", length = 40,note = "业务类型")
    private String businessType;

    /**
     * 业务编码
     */
    @CrmColumn(name = "business_code", length = 100,note = "业务编码")
    private String businessCode;

    /**
     * 客户名称
     */
    @CrmColumn(name = "client_name", length = 100,note = "客户名称")
    private String clientName;

    /**
     * 客户类型
     */
    @CrmColumn(name = "client_type", length = 100,note = "客户类型")
    private String clientType;

    /**
     * 客户类型
     */
    @CrmColumn(name = "client_type_name", length = 100,note = "客户类型")
    private String clientTypeName;

    /**
     * 客户细类
     */
    @CrmColumn(name = "client_subclass", length = 100,note = "客户细类")
    private String clientSubclass;

    /**
     * 客户细类
     */
    @CrmColumn(name = "client_subclass_name", length = 100,note = "客户细类")
    private String clientSubclassName;

    /**
     * 客户细类
     */
    @CrmColumn(name = "visit_plan_info_id", length = 100,note = "拜访计划明细id")
    private String visitPlanInfoId;

    /**
     * 步骤编码
     */
    @CrmColumn(name = "step_code", length = 100,note = "步骤编码")
    private String stepCode;
}