package com.biz.crm.customer.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.customer.mapper.SfaCustomerVisitTotalMapper;
import com.biz.crm.customer.service.SfaCustomerVisitTotalService;
import com.biz.crm.nebular.sfa.customer.resp.SfaCustomerVisitTotalRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitdealer.model.SfaVisitDealerDetailEntity;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.List;

/**
 * @author yangshan
 * @date 2021/3/4 22:41
 */
@Slf4j
@Service
public class SfaCustomerVisitTotalServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaCustomerVisitTotalMapper, SfaVisitDealerDetailEntity> implements SfaCustomerVisitTotalService {

    @Autowired
    private SfaCustomerVisitTotalMapper sfaCustomerVisitTotalMapper;

    @Override
    public List<SfaCustomerVisitTotalRespVo> findCustomerVisitTotal(String clientCode) {
        UserRedis user = UserUtils.getUser();
        AssertUtils.isNotNull(user, "未获取到当前登陆人");
        return sfaCustomerVisitTotalMapper.findCustomerVisitTotal(user.getPoscode(), clientCode);
    }
}
