package com.biz.crm.enums;

/**
 * @Author hej
 * @Created Date 2020-11-18
 **/
public enum SfaTaskReleaseEnum {

    // 0待执行 1部分完成 2已完成 3未完成 4已拒绝 5已过期
    WAIT_EXECUTE("0","待执行"),
    PARTLY_COMPLETED("1","部分完成"),
    EXECUTE_LODING("2","已完成"),
    UNFINISHED("3","未完成"),
    ALREADY_FINISH("4","已拒绝"),
    PAST_DUE("5","已过期");


    private String code;
    private String desc;

    private SfaTaskReleaseEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    private String code(){
        return this.code;
    }

    private String desc(){
        return this.desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static String getValue(String code) {
        SfaTaskReleaseEnum[] sfaTaskStatusEnums = values();
        for (SfaTaskReleaseEnum sfaTaskReleaseEnum : sfaTaskStatusEnums) {
            if (sfaTaskReleaseEnum.code().equals(code)) {
                return sfaTaskReleaseEnum.desc();
            }
        }
        return null;
    }

    public static String getType(String desc) {
        SfaTaskReleaseEnum[] sfaTaskStatusEnums = values();
        for (SfaTaskReleaseEnum sfaTaskReleaseEnum : sfaTaskStatusEnums) {
            if (sfaTaskReleaseEnum.desc().equals(desc)) {
                return sfaTaskReleaseEnum.code();
            }
        }
        return null;
    }


}
