package com.biz.crm.enums;

/**
 * @Project crm-core
 * @PackageName com.biz.crm.enums
 * @Author lifei
 * @Date 2020/11/11
 * @Description
 */
public enum SfaVisitRoleEnum {

    VISIT_ROLE_VISIT("visit","拜访"),
    VISIT_ROLE_HELP_DEFENSE("helpDefense","协防"),

    VISIT_CUS_DEALER("dealer","经销商"),
    VISIT_CUS_BATCH_DEALER("batchDealer","分销商"),
    VISIT_CUS_TERMINAL("terminal","终端"),


    VISIT_STEP_IN_STORE("inStore","进店打卡"),
    VISIT_STEP_OUT_STORE("outStore","离店打卡"),
    VISIT_STEP_STOCK("stock","库存盘点"),
    VISIT_STEP_COMPETITOR("competitor","竞品采集"),
    VISIT_STEP_ORDER("order","代客下单"),
    VISIT_STEP_DISPLAY("display","陈列检查"),
    VISIT_STEP_SUMMARY("summary","拜访总结"),
    VISIT_STEP_ADVERT("advert","广告推广"),
    VISIT_STEP_ATMOSPHERE("atmosphere","氛围检查"),
    VISIT_STEP_TERMINAL("terminalCheck","终端检核"),



    YES("yes","是"),
    NO("no","否"),
    ;


    private String code;
    private String desc;

    SfaVisitRoleEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static SfaVisitRoleEnum getSfaVisitRole(String code){
        for (SfaVisitRoleEnum role:SfaVisitRoleEnum.values()) {
            if (code.equals(role.getCode())){
                return role;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
