package com.biz.crm.freesignconfig.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.freesignconfig.service.ISfaFreesignConfigService;
import com.biz.crm.nebular.sfa.freesignconfig.resp.SfaFreesignConfigRespVo;
import com.biz.crm.nebular.sfa.freesignconfig.req.SfaFreesignConfigReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 签到组 
 *
 * @author liuhongming
 * @date 2020-09-17 14:40:27
 */
@Slf4j
@RestController
@RequestMapping("/sfafreesignconfig")
@Api(tags = "后台-考勤管理-签到组（废弃）")
public class SfaFreesignConfigController {
    @Autowired
    private ISfaFreesignConfigService sfaFreesignConfigService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaFreesignConfigRespVo>> list(@RequestBody SfaFreesignConfigReqVo sfaFreesignConfigReqVo) {
        PageResult<SfaFreesignConfigRespVo> result=sfaFreesignConfigService.findList(sfaFreesignConfigReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaFreesignConfigRespVo> query(@RequestBody SfaFreesignConfigReqVo sfaFreesignConfigReqVo) {
        SfaFreesignConfigRespVo respVo=sfaFreesignConfigService.query(sfaFreesignConfigReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaFreesignConfigReqVo sfaFreesignConfigReqVo) {
        sfaFreesignConfigService.save(sfaFreesignConfigReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaFreesignConfigReqVo sfaFreesignConfigReqVo) {
        sfaFreesignConfigService.update(sfaFreesignConfigReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaFreesignConfigReqVo sfaFreesignConfigReqVo) {
        sfaFreesignConfigService.deleteBatch(sfaFreesignConfigReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaFreesignConfigReqVo sfaFreesignConfigReqVo) {
        sfaFreesignConfigService.enableBatch(sfaFreesignConfigReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaFreesignConfigReqVo sfaFreesignConfigReqVo) {
        sfaFreesignConfigService.disableBatch(sfaFreesignConfigReqVo);
        return Result.ok("禁用成功");
    }
}
