package com.biz.crm.freesignconfig.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.freesignconfig.service.ISfaFreesignPersonnelService;
import com.biz.crm.nebular.sfa.freesignconfig.resp.SfaFreesignPersonnelRespVo;
import com.biz.crm.nebular.sfa.freesignconfig.req.SfaFreesignPersonnelReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 签到组-打卡人员 
 *
 * @author liuhongming
 * @date 2020-09-17 14:40:27
 */
@Slf4j
@RestController
@RequestMapping("/sfafreesignpersonnel")
@Api(tags = "签到组-打卡人员 ")
public class SfaFreesignPersonnelController {
    @Autowired
    private ISfaFreesignPersonnelService sfaFreesignPersonnelService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaFreesignPersonnelRespVo>> list(@RequestBody SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo) {
        PageResult<SfaFreesignPersonnelRespVo> result=sfaFreesignPersonnelService.findList(sfaFreesignPersonnelReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaFreesignPersonnelRespVo> query(@RequestBody SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo) {
        SfaFreesignPersonnelRespVo respVo=sfaFreesignPersonnelService.query(sfaFreesignPersonnelReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo) {
        sfaFreesignPersonnelService.save(sfaFreesignPersonnelReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo) {
        sfaFreesignPersonnelService.update(sfaFreesignPersonnelReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo) {
        sfaFreesignPersonnelService.deleteBatch(sfaFreesignPersonnelReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo) {
        sfaFreesignPersonnelService.enableBatch(sfaFreesignPersonnelReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo) {
        sfaFreesignPersonnelService.disableBatch(sfaFreesignPersonnelReqVo);
        return Result.ok("禁用成功");
    }
}
