package com.biz.crm.freesignconfig.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 签到组 实体类
 *
 * @author liuhongming
 * @date 2020-09-17 14:40:27
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_freesign_config")
@CrmTable(name = "sfa_freesign_config", tableNote = "签到组")
public class SfaFreesignConfigEntity extends CrmExtTenEntity<SfaFreesignConfigEntity> {

    /**
     * 签到组编码 签到组编码
     */
    @CrmColumn(name = "freesign_code", length = 32, note = "签到组编码")
    private String freesignCode;

    /**
     * 签到组名称 签到组名称
     */
    @CrmColumn(name = "freesign_name", length = 100, note = "签到组名称")
    private String freesignName;

    /**
     * 打卡类型编码 打卡类型编码
     */
    @CrmColumn(name = "sign_type_code", length = 32, note = "打卡类型编码")
    private String signTypeCode;

    /**
     * 打卡类型名称 打卡类型名称
     */
    @CrmColumn(name = "sign_type_name", length = 100, note = "打卡类型名称")
    private String signTypeName;

}
