package com.biz.crm.freesignconfig.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 签到组--打卡类型 实体类
 *
 * @author liuhongming
 * @date 2020-09-17 14:40:27
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_freesign_sign_type")
@CrmTable(name = "sfa_freesign_sign_type", tableNote = "签到组--打卡类型 ")
public class SfaFreesignSignTypeEntity extends CrmExtTenEntity<SfaFreesignSignTypeEntity> {

    /**
     * 序号 序号
     */
    @CrmColumn(name = "order_number", length = 32, note = "序号 序号")
    private String orderNumber;

    /**
     * 打卡类型编码 打卡类型编码
     */
    @CrmColumn(name = "sign_type_code", length = 32, note = "打卡类型编码 打卡类型编码")
    private String signTypeCode;

    /**
     * 名称 名称
     */
    @CrmColumn(name = "sign_type_name", length = 32, note = "名称 名称")
    private String signTypeName;

    /**
     * 拍照要求 拍照要求（1:是；0：否）
     */
    @CrmColumn(name = "photo_req", length = 32, note = "拍照要求 拍照要求（1:是；0：否）")
    private String photoReq;

    /**
     * 时间要求 时间要求（1:是；0：否）
     */
    @CrmColumn(name = "time_req", length = 512, note = "时间要求 时间要求（1:是；0：否）")
    private String timeReq;

    /**
     * 开始时间 开始时间（HH:mm:dd）
     */
    @CrmColumn(name = "begin_date", length = 32, note = "开始时间（HH:mm:dd）")
    private String beginDate;

    /**
     * 结束时间 结束时间（HH:mm:dd）
     */
    @CrmColumn(name = "end_date", length = 32, note = "结束时间（HH:mm:dd）")
    private String endDate;

}
