package com.biz.crm.freesignconfig.service;

import com.biz.crm.freesignconfig.model.SfaFreesignPersonnelEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.freesignconfig.resp.SfaFreesignPersonnelRespVo;
import com.biz.crm.nebular.sfa.freesignconfig.req.SfaFreesignPersonnelReqVo;

import java.util.Map;

/**
 * 签到组-打卡人员 接口
 *
 * @author liuhongming
 * @date 2020-09-17 14:40:27
 */
public interface ISfaFreesignPersonnelService extends IService<SfaFreesignPersonnelEntity> {

    /**
     * 列表
     * @param sfaFreesignPersonnelReqVo
     * @return PageResult<SfaFreesignPersonnelRespVo>
     */
    PageResult<SfaFreesignPersonnelRespVo> findList(SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo);

    /**
     * 查询
     * @param sfaFreesignPersonnelReqVo
     * @return SfaFreesignPersonnelRespVo
     */
    SfaFreesignPersonnelRespVo query(SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo);

    /**
     * 新增
     * @param sfaFreesignPersonnelReqVo
     * @return
     */
    void save(SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo);

    /**
     * 更新
     * @param sfaFreesignPersonnelReqVo
     * @return
     */
    void update(SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo);

    /**
     * 删除
     * @param sfaFreesignPersonnelReqVo
     * @return
     */
    void deleteBatch(SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo);

    /**
     * 启用
     * @param sfaFreesignPersonnelReqVo
     * @return
     */
    void enableBatch(SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo);

    /**
     * 禁用
     * @param sfaFreesignPersonnelReqVo
     * @return
     */
    void disableBatch(SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo);
}

