package com.biz.crm.freesignconfig.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.freesignconfig.mapper.SfaFreesignConfigMapper;
import com.biz.crm.freesignconfig.mapper.SfaFreesignPersonnelMapper;
import com.biz.crm.freesignconfig.mapper.SfaFreesignSignMapper;
import com.biz.crm.freesignconfig.mapper.SfaFreesignSignTypeMapper;
import com.biz.crm.freesignconfig.model.SfaFreesignConfigEntity;
import com.biz.crm.freesignconfig.model.SfaFreesignPersonnelEntity;
import com.biz.crm.freesignconfig.model.SfaFreesignSignEntity;
import com.biz.crm.freesignconfig.model.SfaFreesignSignTypeEntity;
import com.biz.crm.freesignconfig.service.ISfaFreesignConfigService;
import com.biz.crm.freesignconfig.service.ISfaFreesignPersonnelService;
import com.biz.crm.freesignconfig.service.ISfaFreesignSignService;
import com.biz.crm.freesignconfig.service.ISfaFreesignSignTypeService;
import com.biz.crm.nebular.sfa.freesignconfig.req.SfaFreesignConfigReqVo;
import com.biz.crm.nebular.sfa.freesignconfig.req.SfaFreesignPersonnelReqVo;
import com.biz.crm.nebular.sfa.freesignconfig.req.SfaFreesignSignReqVo;
import com.biz.crm.nebular.sfa.freesignconfig.req.SfaFreesignSignTypeReqVo;
import com.biz.crm.nebular.sfa.freesignconfig.resp.SfaFreesignConfigRespVo;
import com.biz.crm.nebular.sfa.freesignconfig.resp.SfaFreesignPersonnelRespVo;
import com.biz.crm.nebular.sfa.freesignconfig.resp.SfaFreesignSignRespVo;
import com.biz.crm.nebular.sfa.freesignconfig.resp.SfaFreesignSignTypeRespVo;
import com.biz.crm.util.*;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 签到组 接口实现
 *
 * @author liuhongming
 * @date 2020-09-17 14:40:27
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaFreesignConfigServiceExpandImpl")
public class SfaFreesignConfigServiceImpl extends ServiceImpl<SfaFreesignConfigMapper, SfaFreesignConfigEntity> implements ISfaFreesignConfigService {

    @Resource
    private SfaFreesignConfigMapper sfaFreesignConfigMapper;
    @Resource
    private SfaFreesignPersonnelMapper personnelMapper;
    @Resource
    private SfaFreesignSignTypeMapper freesignSignTypeMapper;
    @Resource
    private SfaFreesignSignMapper sfaFreesignSignMapper;

    @Autowired
    private ISfaFreesignPersonnelService iSfaFreesignPersonnelService;
    @Autowired
    private ISfaFreesignSignTypeService iSfaFreesignSignTypeServics;
    @Autowired
    private ISfaFreesignSignService iSfaFreesignSignService;


    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    @CrmLog
    public PageResult<SfaFreesignConfigRespVo> findList(SfaFreesignConfigReqVo reqVo){
        Page<SfaFreesignConfigRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaFreesignConfigRespVo> list = sfaFreesignConfigMapper.findList(page, reqVo);
        return PageResult.<SfaFreesignConfigRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaFreesignConfigRespVo
     */
    @Override
    @CrmLog
    public SfaFreesignConfigRespVo query(SfaFreesignConfigReqVo reqVo){
        List<SfaFreesignConfigRespVo> list = this.findList(reqVo).getData();
        if(CollectionUtils.isEmpty(list)){
            return new SfaFreesignConfigRespVo();
        }
        SfaFreesignConfigRespVo sfaFreesignConfigRespVo = list.get(0);
        //打卡人员
        SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo = new SfaFreesignPersonnelReqVo();
        sfaFreesignPersonnelReqVo.setFreesignCode(sfaFreesignConfigRespVo.getFreesignCode());
        sfaFreesignPersonnelReqVo.setPageSize(-1);
        List<SfaFreesignPersonnelRespVo> sfaWorkSignPersonnelRespVos =
                iSfaFreesignPersonnelService.findList(sfaFreesignPersonnelReqVo).getData();
        if (CollectionUtil.listEmpty(sfaWorkSignPersonnelRespVos)){
            //打卡人员包含
            List<SfaFreesignPersonnelRespVo> personnelRespContainVos = new ArrayList<>();
            //打卡人员非包含
            List<SfaFreesignPersonnelRespVo> personnelRespNonInclusionVos = new ArrayList<>();
            for (SfaFreesignPersonnelRespVo personnelRespVo:sfaWorkSignPersonnelRespVos){
                if ("1".equals(personnelRespVo.getRangeType())){
                    personnelRespContainVos.add(personnelRespVo);
                }else{
                    personnelRespNonInclusionVos.add(personnelRespVo);
                }
            }
            sfaFreesignConfigRespVo.setPersonnelRespContainVos(personnelRespContainVos);
            sfaFreesignConfigRespVo.setPersonnelRespNonInclusionVos(personnelRespNonInclusionVos);
        }
        return sfaFreesignConfigRespVo;
    }

    /**
     * 新增,编辑,校验
     * @param reqVo
     */
    public void saveCheck(SfaFreesignConfigReqVo reqVo){
        AssertUtils.isNotEmpty(reqVo.getFreesignName(),"请输入签到组名称");
        AssertUtils.isNotEmpty(reqVo.getSignTypeCode(),"请选择打卡类型");
        AssertUtils.isNotEmpty(reqVo.getSignTypeName(),"请选择打卡类型");

        SfaFreesignSignTypeReqVo sfaFreesignSignTypeReqVo = new SfaFreesignSignTypeReqVo();
        sfaFreesignSignTypeReqVo.setSignTypeCode(reqVo.getSignTypeCode());
        List<SfaFreesignSignTypeRespVo> freesignSignTypeRespVoList =
                iSfaFreesignSignTypeServics.findList(sfaFreesignSignTypeReqVo).getData();
        if (CollectionUtil.listEmpty(freesignSignTypeRespVoList)){
            throw new BusinessException("选择打卡类型有误,系统不存在该【"+reqVo.getSignTypeName()+"】打卡类型");
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getPersonnelReqContainVos())){
            for (SfaFreesignPersonnelReqVo personnelReqContainVo:reqVo.getPersonnelReqContainVos()){
                personnelReqContainVo.setRangeType("1");
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getPersonnelReqNonInclusionVos())){
            for (SfaFreesignPersonnelReqVo personnelReqNonInclusionVo:reqVo.getPersonnelReqNonInclusionVos()){
                personnelReqNonInclusionVo.setRangeType("1");
            }
        }
        this.checkDataExist(reqVo);
    }

    /**
     * 校验数据是否已经存在
     * @param reqVo
     * @return
     */
    public void checkDataExist(SfaFreesignConfigReqVo reqVo ) {
        LambdaQueryWrapper<SfaFreesignConfigEntity> wrapper = new LambdaQueryWrapper<SfaFreesignConfigEntity>().eq(SfaFreesignConfigEntity::getFreesignName,reqVo.getFreesignName());
        if(StringUtils.isNotEmpty(reqVo.getId())){
            wrapper.ne(SfaFreesignConfigEntity::getId,reqVo.getId());
        }
        SfaFreesignConfigEntity entity = sfaFreesignConfigMapper.selectOne(wrapper);
        AssertUtils.isNotNull(entity, "签到组数据名称重复,请检查");
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void save(SfaFreesignConfigReqVo reqVo){
        this.saveCheck(reqVo);
        SfaFreesignConfigEntity entity = CrmBeanUtil.copy(reqVo,SfaFreesignConfigEntity.class);
        //TODO 签到组编码
        String code = CodeUtil.createCode();
        entity.setFreesignCode(code);
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.save(entity);
        this.saveData(reqVo,entity);
    }

    /**
     * 保存业务明细数据
     * @param reqVo
     * @param entity
     */
    public void saveData(SfaFreesignConfigReqVo reqVo, SfaFreesignConfigEntity entity){
        String[] signTypeCodes = reqVo.getSignTypeCode().split(",");
        if (signTypeCodes.length>0){
            List<String> signTypeCodeList = Arrays.asList(signTypeCodes);
            LambdaQueryWrapper<SfaFreesignSignTypeEntity> wrapper = new LambdaQueryWrapper<SfaFreesignSignTypeEntity>()
                    .in(SfaFreesignSignTypeEntity::getSignTypeCode,signTypeCodeList);
            List<SfaFreesignSignTypeEntity> freesignSignTypeList = freesignSignTypeMapper.selectList(wrapper);
            if (CollectionUtil.listNotEmptyNotSizeZero(freesignSignTypeList)){
                List<SfaFreesignSignEntity> freesignSignList = freesignSignTypeList.stream().map(o -> {
                    SfaFreesignSignEntity freesignSign = new SfaFreesignSignEntity();
                    freesignSign.setFreesignCode(entity.getFreesignCode());
                    freesignSign.setSignTypeId(o.getId());
                    freesignSign.setSignTypeCode(o.getSignTypeCode());
                    freesignSign.setSignTypeName(o.getSignTypeName());
                    return freesignSign;
                }).collect(Collectors.toList());
                iSfaFreesignSignService.saveBatch(freesignSignList);
            }
        }
        //打卡人员 包含
        List<SfaFreesignPersonnelEntity> personnelEntityList = new ArrayList<>();
        if (CollectionUtil.listEmpty(reqVo.getPersonnelReqContainVos())){
            List<SfaFreesignPersonnelEntity> personnelContainList = reqVo.getPersonnelReqContainVos().stream().map(o -> {
                SfaFreesignPersonnelEntity personnelEntity = new SfaFreesignPersonnelEntity();
                CrmBeanUtil.copyProperties(o, personnelEntity);
                personnelEntity.setFreesignCode(entity.getFreesignCode());
                personnelEntity.setRangeType("1");
                return personnelEntity;
            }).collect(Collectors.toList());
            personnelEntityList.addAll(personnelContainList);
        }
        //打卡人员 非包含
        if (CollectionUtil.listEmpty(reqVo.getPersonnelReqNonInclusionVos())){
            List<SfaFreesignPersonnelEntity> personnelNonInclusionList = reqVo.getPersonnelReqNonInclusionVos().stream().map(o -> {
                SfaFreesignPersonnelEntity personnelEntity = new SfaFreesignPersonnelEntity();
                CrmBeanUtil.copyProperties(o, personnelEntity);
                personnelEntity.setFreesignCode(entity.getFreesignCode());
                personnelEntity.setRangeType("2");
                return personnelEntity;
            }).collect(Collectors.toList());
            personnelEntityList.addAll(personnelNonInclusionList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(personnelEntityList)){
            iSfaFreesignPersonnelService.saveBatch(personnelEntityList);
        }

    }



    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void update(SfaFreesignConfigReqVo reqVo){
        if(StringUtils.isEmpty(reqVo.getId())){
            throw new BusinessException("数据主键不能为空");
        }
        SfaFreesignConfigEntity entity = this.getById(reqVo.getId());
        if(Objects.isNull(entity)){
            throw new BusinessException("考勤规则数据不存在");
        }
        this.saveCheck(reqVo);
        this.updateById(entity);
        this.deleteBatchDate(reqVo);
        this.saveData(reqVo,entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void deleteBatch(SfaFreesignConfigReqVo reqVo){
        if(StringUtils.isEmpty(reqVo.getId())&&CollectionUtil.listEmpty(reqVo.getIds())){
            throw new BusinessException("数据主键不能为空");
        }
        List<SfaFreesignConfigRespVo> list = this.findList(reqVo).getData();
        if(CollectionUtils.isEmpty(list)){
            throw new BusinessException("考勤规则数据不存在");
        }
        reqVo.setPageSize(-1);
        sfaFreesignConfigMapper.deleteProductsByParams(reqVo);
        List<String> codes = list.stream().map(SfaFreesignConfigRespVo :: getFreesignCode).collect(Collectors.toList());
        reqVo.setFreesignCodes(codes);
        this.deleteBatchDate(reqVo);
    }

    public void deleteBatchDate(SfaFreesignConfigReqVo reqVo){
        if(StringUtils.isEmpty(reqVo.getFreesignCode())&&CollectionUtil.listEmpty(reqVo.getFreesignCodes())){
            throw new BusinessException("数据主键不能为空");
        }
        //签到组与打开类型关系表
        SfaFreesignSignReqVo sfaFreesignSignReqVo = new SfaFreesignSignReqVo();
        sfaFreesignSignReqVo.setFreesignCode(reqVo.getFreesignCode());
        sfaFreesignSignReqVo.setFreesignCodes(reqVo.getFreesignCodes());
        sfaFreesignSignMapper.deleteProductsByParams(sfaFreesignSignReqVo);
        //打卡人员
        SfaFreesignPersonnelReqVo signPersonnelReqVo = new SfaFreesignPersonnelReqVo();
        signPersonnelReqVo.setFreesignCode(reqVo.getFreesignCode());
        signPersonnelReqVo.setFreesignCodes(reqVo.getFreesignCodes());
        personnelMapper.deleteProductsByParams(signPersonnelReqVo);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void enableBatch(SfaFreesignConfigReqVo reqVo){
        if(StringUtils.isEmpty(reqVo.getId())&&CollectionUtil.listEmpty(reqVo.getIds())){
            throw new BusinessException("数据主键不能为空");
        }
        if (StringUtils.isNotEmpty(reqVo.getId())){
            List<String> ids = new ArrayList<>();
            if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getIds())){
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        //设置状态为启用
        List<SfaFreesignConfigEntity> sfaFreesignConfigEntities = sfaFreesignConfigMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaFreesignConfigEntities)){
            sfaFreesignConfigEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaFreesignConfigEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void disableBatch(SfaFreesignConfigReqVo reqVo){
        if(StringUtils.isEmpty(reqVo.getId())&&CollectionUtil.listEmpty(reqVo.getIds())){
            throw new BusinessException("数据主键不能为空");
        }
        if (StringUtils.isNotEmpty(reqVo.getId())){
            List<String> ids = new ArrayList<>();
            if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getIds())){
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        //设置状态为禁用
        List<SfaFreesignConfigEntity> sfaFreesignConfigEntities = sfaFreesignConfigMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaFreesignConfigEntities)){
                sfaFreesignConfigEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaFreesignConfigEntities);
    }


    @Override
    @CrmLog
    public Result<SfaFreesignConfigRespVo> findFreesignConfigList(){
        Result<SfaFreesignConfigRespVo> result = new Result<>();
        //获取当前登录人信息
        UserRedis userRedis = UserUtils.getUser();
        if (null==userRedis|| StringUtil.isEmpty(userRedis.getUsername())){
            result.error401("请重新登录");
            return result;
        }
        List<SfaFreesignConfigRespVo> sfaFreesignConfigRespVos = new ArrayList<>();
        LambdaQueryWrapper<SfaFreesignConfigEntity> wrapper = new LambdaQueryWrapper<SfaFreesignConfigEntity>()
                .eq(SfaFreesignConfigEntity::getEnableStatus,CrmEnableStatusEnum.ENABLE.getCode())
                .eq(SfaFreesignConfigEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode());
        wrapper.orderByDesc(SfaFreesignConfigEntity::getFreesignCode);
        List<SfaFreesignConfigEntity> freesignConfigList  = sfaFreesignConfigMapper.selectList(wrapper);
        if (CollectionUtil.listNotEmptyNotSizeZero(freesignConfigList)){
            for (SfaFreesignConfigEntity sfaFreesignConfig:freesignConfigList){
                //查询签到组对应范围 打卡人员
                SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo = new SfaFreesignPersonnelReqVo();
                sfaFreesignPersonnelReqVo.setFreesignCode(sfaFreesignConfig.getFreesignCode());
                sfaFreesignPersonnelReqVo.setPageSize(-1);
                List<SfaFreesignPersonnelRespVo> sfaWorkSignPersonnelRespVos =
                        iSfaFreesignPersonnelService.findList(sfaFreesignPersonnelReqVo).getData();
                //TODO 判断范围是否满足

            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(sfaFreesignConfigRespVos)){
            initSfaFreesignConfigVo(sfaFreesignConfigRespVos);
        }
        result.ok(sfaFreesignConfigRespVos);
        return result;
    }


    private void initSfaFreesignConfigVo(List<SfaFreesignConfigRespVo> list){
        List<String> freesignCodes = new ArrayList<>();
        for (SfaFreesignConfigRespVo freesignConfigRespVo:list){
            freesignCodes.add(freesignConfigRespVo.getFreesignCode());
        }
        SfaFreesignSignReqVo reqVo = new SfaFreesignSignReqVo();
        reqVo.setFreesignCodes(freesignCodes);
        reqVo.setPageSize(-1);
        List<SfaFreesignSignRespVo> sfaFreesignSignRespVos = iSfaFreesignSignService.findList(reqVo).getData();
        Map<String,List<SfaFreesignSignRespVo>> map = new HashMap<>();
        if (CollectionUtil.listNotEmptyNotSizeZero(sfaFreesignSignRespVos)){
            for (SfaFreesignSignRespVo freesignSignRespVo:sfaFreesignSignRespVos ){
                List<SfaFreesignSignRespVo> freesignSignRespVoList = new ArrayList<>();
                if (map.containsKey(freesignSignRespVo.getFreesignCode())){
                    freesignSignRespVoList = map.get(freesignSignRespVo.getFreesignCode());
                }
                map.remove(freesignSignRespVo.getFreesignCode());
                map.put(freesignSignRespVo.getFreesignCode(),freesignSignRespVoList);
            }
        }
        if (map.size()>0){
            for (SfaFreesignConfigRespVo freesignConfigRespVo:list){
                if (map.containsKey(freesignConfigRespVo.getFreesignCode())){
                    List<SfaFreesignSignRespVo> freesignSignRespVoList = map.get(freesignConfigRespVo.getFreesignCode());
                    freesignConfigRespVo.setSfaFreesignSignRespVos(freesignSignRespVoList);
                }
            }
        }
    }


}
