package com.biz.crm.freesignconfig.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.freesignconfig.mapper.SfaFreesignPersonnelMapper;
import com.biz.crm.freesignconfig.model.SfaFreesignPersonnelEntity;
import com.biz.crm.freesignconfig.service.ISfaFreesignPersonnelService;
import com.biz.crm.nebular.sfa.freesignconfig.req.SfaFreesignPersonnelReqVo;
import com.biz.crm.nebular.sfa.freesignconfig.resp.SfaFreesignPersonnelRespVo;
import com.biz.crm.util.CrmBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 签到组-打卡人员 接口实现
 *
 * @author liuhongming
 * @date 2020-09-17 14:40:27
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaFreesignPersonnelServiceExpandImpl")
public class SfaFreesignPersonnelServiceImpl extends ServiceImpl<SfaFreesignPersonnelMapper, SfaFreesignPersonnelEntity> implements ISfaFreesignPersonnelService {

    @Resource
    private SfaFreesignPersonnelMapper sfaFreesignPersonnelMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    @CrmLog
    public PageResult<SfaFreesignPersonnelRespVo> findList(SfaFreesignPersonnelReqVo reqVo){
        Page<SfaFreesignPersonnelRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaFreesignPersonnelRespVo> list = sfaFreesignPersonnelMapper.findList(page, reqVo);
        return PageResult.<SfaFreesignPersonnelRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaFreesignPersonnelRespVo
     */
    @Override
    @CrmLog
    public SfaFreesignPersonnelRespVo query(SfaFreesignPersonnelReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void save(SfaFreesignPersonnelReqVo reqVo){
        SfaFreesignPersonnelEntity entity = CrmBeanUtil.copy(reqVo,SfaFreesignPersonnelEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void update(SfaFreesignPersonnelReqVo reqVo){
        SfaFreesignPersonnelEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void deleteBatch(SfaFreesignPersonnelReqVo reqVo){
        List<SfaFreesignPersonnelEntity> sfaFreesignPersonnelEntities = sfaFreesignPersonnelMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaFreesignPersonnelEntities)){
            sfaFreesignPersonnelEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaFreesignPersonnelEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void enableBatch(SfaFreesignPersonnelReqVo reqVo){
        //设置状态为启用
        List<SfaFreesignPersonnelEntity> sfaFreesignPersonnelEntities = sfaFreesignPersonnelMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaFreesignPersonnelEntities)){
            sfaFreesignPersonnelEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaFreesignPersonnelEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void disableBatch(SfaFreesignPersonnelReqVo reqVo){
        //设置状态为禁用
        List<SfaFreesignPersonnelEntity> sfaFreesignPersonnelEntities = sfaFreesignPersonnelMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaFreesignPersonnelEntities)){
                sfaFreesignPersonnelEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaFreesignPersonnelEntities);
    }
}
