package com.biz.crm.freesignconfig.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.freesignconfig.mapper.SfaFreesignSignTypeMapper;
import com.biz.crm.freesignconfig.model.SfaFreesignSignTypeEntity;
import com.biz.crm.freesignconfig.service.ISfaFreesignSignTypeService;
import com.biz.crm.nebular.sfa.freesignconfig.req.SfaFreesignSignTypeReqVo;
import com.biz.crm.nebular.sfa.freesignconfig.resp.SfaFreesignSignTypeRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * 签到组--打卡类型 接口实现
 *
 * @author liuhongming
 * @date 2020-09-17 14:40:27
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaFreesignSignTypeServiceExpandImpl")
public class SfaFreesignSignTypeServiceImpl extends ServiceImpl<SfaFreesignSignTypeMapper, SfaFreesignSignTypeEntity> implements ISfaFreesignSignTypeService {

    @Resource
    private SfaFreesignSignTypeMapper sfaFreesignSignTypeMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    @CrmLog
    public PageResult<SfaFreesignSignTypeRespVo> findList(SfaFreesignSignTypeReqVo reqVo){
        Page<SfaFreesignSignTypeRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaFreesignSignTypeRespVo> list = sfaFreesignSignTypeMapper.findList(page, reqVo);
        return PageResult.<SfaFreesignSignTypeRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaFreesignSignTypeRespVo
     */
    @Override
    @CrmLog
    public SfaFreesignSignTypeRespVo query(SfaFreesignSignTypeReqVo reqVo){
        List<SfaFreesignSignTypeRespVo> list = this.findList(reqVo).getData();
        if(CollectionUtils.isEmpty(list)){
            return new SfaFreesignSignTypeRespVo();
        }
        SfaFreesignSignTypeRespVo sfaFreesignSignTypeRespVo = list.get(0);
        return sfaFreesignSignTypeRespVo;
    }

    public void saveCheck(SfaFreesignSignTypeReqVo reqVo){
        AssertUtils.isNotEmpty(reqVo.getOrderNumber(),"请输入序号");
        AssertUtils.isNotEmpty(reqVo.getSignTypeName(),"请输入名称");
        AssertUtils.isNotEmpty(reqVo.getPhotoReq(),"请选择拍照要求");
        AssertUtils.isNotEmpty(reqVo.getTimeReq(),"请选择时间要求");
        if ("1".equals(reqVo.getTimeReq())){
            SimpleDateFormat hms  =new SimpleDateFormat("HH:mm:ss");
            AssertUtils.isNotEmpty(reqVo.getBeginDate(), "开始时间不能为空");
            Date beginDate = null;
            try{
                beginDate = (Date) hms.parse(reqVo.getBeginDate());
            }catch(Exception e){
                throw new BusinessException("开始时间格式错误");
            }
            AssertUtils.isNotEmpty(reqVo.getEndDate(), "结束时间不能为空");
            Date endDate = null;
            try{
                endDate = (Date) hms.parse(reqVo.getEndDate());
            }catch(Exception e){
                throw new BusinessException("结束时间格式错误");
            }
            if (!(beginDate.getTime() < endDate.getTime())){
                throw new BusinessException("开始时间不能大于结束时间");
            }
        }
        this.checkDataExist(reqVo);
    }

    /**
     * 校验数据是否已经存在
     * @param reqVo
     * @return
     */
    public void checkDataExist(SfaFreesignSignTypeReqVo reqVo ) {
        LambdaQueryWrapper<SfaFreesignSignTypeEntity> wrapper = new LambdaQueryWrapper<SfaFreesignSignTypeEntity>().eq(SfaFreesignSignTypeEntity::getOrderNumber,reqVo.getOrderNumber());
        if(StringUtils.isNotEmpty(reqVo.getId())){
            wrapper.ne(SfaFreesignSignTypeEntity::getId,reqVo.getId());
        }
        SfaFreesignSignTypeEntity entity = sfaFreesignSignTypeMapper.selectOne(wrapper);
        AssertUtils.isNotNull(entity, "打卡类型数据序号重复,请检查");

        /*LambdaQueryWrapper<SfaFreesignSignTypeEntity> wrapper2 = new LambdaQueryWrapper<SfaFreesignSignTypeEntity>().eq(SfaFreesignSignTypeEntity::getSignTypeName,reqVo.getSignTypeName());
        if(StringUtils.isNotEmpty(reqVo.getId())){
            wrapper2.ne(SfaFreesignSignTypeEntity::getId,reqVo.getId());
        }
        SfaFreesignSignTypeEntity entity2 = sfaFreesignSignTypeMapper.selectOne(wrapper2);
        AssertUtils.isNotNull(entity2, "打卡类型数据名称重复,请检查");*/
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void save(SfaFreesignSignTypeReqVo reqVo){
        this.saveCheck(reqVo);
        SfaFreesignSignTypeEntity entity = CrmBeanUtil.copy(reqVo,SfaFreesignSignTypeEntity.class);
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void update(SfaFreesignSignTypeReqVo reqVo){
        if(StringUtils.isEmpty(reqVo.getId())){
            throw new BusinessException("数据主键不能为空");
        }
        SfaFreesignSignTypeEntity entity = this.getById(reqVo.getId());
        if(Objects.isNull(entity)){
            throw new BusinessException("打卡类型数据不存在");
        }
        saveCheck(reqVo);
        CrmBeanUtil.copyProperties(reqVo,entity);
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void deleteBatch(SfaFreesignSignTypeReqVo reqVo){
        if(StringUtils.isEmpty(reqVo.getId())&& CollectionUtil.listEmpty(reqVo.getIds())){
            throw new BusinessException("数据主键不能为空");
        }
        sfaFreesignSignTypeMapper.deleteProductsByParams(reqVo);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void enableBatch(SfaFreesignSignTypeReqVo reqVo){
        if(StringUtils.isEmpty(reqVo.getId())&&CollectionUtil.listEmpty(reqVo.getIds())){
            throw new BusinessException("数据主键不能为空");
        }
        if (StringUtils.isNotEmpty(reqVo.getId())){
            List<String> ids = new ArrayList<>();
            if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getIds())){
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        //设置状态为启用
        List<SfaFreesignSignTypeEntity> sfaFreesignSignTypeEntities = sfaFreesignSignTypeMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaFreesignSignTypeEntities)){
            sfaFreesignSignTypeEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaFreesignSignTypeEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void disableBatch(SfaFreesignSignTypeReqVo reqVo){
        if(StringUtils.isEmpty(reqVo.getId())&&CollectionUtil.listEmpty(reqVo.getIds())){
            throw new BusinessException("数据主键不能为空");
        }
        if (StringUtils.isNotEmpty(reqVo.getId())){
            List<String> ids = new ArrayList<>();
            if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getIds())){
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        //设置状态为禁用
        List<SfaFreesignSignTypeEntity> sfaFreesignSignTypeEntities = sfaFreesignSignTypeMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaFreesignSignTypeEntities)){
                sfaFreesignSignTypeEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaFreesignSignTypeEntities);
    }
}
