package com.biz.crm.helpdefense.controller;

import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.helpdefense.service.ISfaHelpDefenseService;
import com.biz.crm.nebular.sfa.helpdefense.req.SfaHelpDefenseReqVo;
import com.biz.crm.nebular.sfa.helpdefense.resp.SfaHelpDefenseRespVo;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.visitstep.req.GetHelpVisitEvaluateTableReq;
import com.biz.crm.visitstep.resp.SfaHelpVisitEvaluateTableRespVo;
import com.biz.crm.visitstep.service.impl.SfaVisitStepHelpScoreTableEsImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 协访执行;
 *
 * @author lf
 * @date 2021-01-05 15:45:45
 */
@Slf4j
@RestController
@RequestMapping("/sfaHelpDefenseController")
@Api(tags = "协访执行;")
public class SfaHelpDefenseController {
    @Resource
    private ISfaHelpDefenseService sfaHelpDefenseService;

    @Resource
    private SfaVisitStepHelpScoreTableEsImpl sfaVisitStepHelpScoreTableEs;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaHelpDefenseRespVo>> list(@RequestBody SfaHelpDefenseReqVo sfaHelpDefenseReqVo) {
        PageResult<SfaHelpDefenseRespVo> result=sfaHelpDefenseService.findList(sfaHelpDefenseReqVo);
        return Result.ok(result);
    }

    /**
     * 通过主键id查询详情
     */
    @ApiOperation(value = "通过主键id查询详情")
    @GetMapping("/queryDetailById")
    @CrmLog
    public Result<SfaHelpDefenseRespVo> queryDetailById(@RequestParam String id) {
        SfaHelpDefenseRespVo respVo=sfaHelpDefenseService.queryDetailById(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaHelpDefenseReqVo sfaHelpDefenseReqVo) {
        sfaHelpDefenseService.save(sfaHelpDefenseReqVo);
        return Result.ok();
    }

    /**
     * 查询被协访的拜访网点信息
     * @param reqVo
     * @return
     */
    @ApiOperation(value = "查询被协访的拜访网点信息")
    @PostMapping("findSfaVisitPlanInfoList")
    @CrmLog
    public Result<List<SfaVisitPlanInfoRespVo>> findSfaVisitPlanInfoList(@RequestBody SfaVisitPlanInfoReqVo reqVo){
        List<SfaVisitPlanInfoRespVo> pageResult = sfaHelpDefenseService.findSfaVisitPlanInfoList(reqVo);
        return Result.ok(pageResult);
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    @Deprecated
    @CrmAPIDiscard
    public Result update(@RequestBody SfaHelpDefenseReqVo sfaHelpDefenseReqVo) {
        sfaHelpDefenseService.update(sfaHelpDefenseReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        sfaHelpDefenseService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaHelpDefenseReqVo sfaHelpDefenseReqVo) {
        sfaHelpDefenseService.enableBatch(sfaHelpDefenseReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaHelpDefenseReqVo sfaHelpDefenseReqVo) {
        sfaHelpDefenseService.disableBatch(sfaHelpDefenseReqVo);
        return Result.ok("禁用成功");
    }

    /**
     * 协访评价报表
     */
    @ApiOperation(value = "协访评价报表")
    @PostMapping("/getHelpVisitEvaluateTable")
    public Result<PageResult<SfaHelpVisitEvaluateTableRespVo>> getHelpVisitEvaluateTable(@RequestBody GetHelpVisitEvaluateTableReq req) {
        return Result.ok(sfaVisitStepHelpScoreTableEs.getHelpVisitEvaluateTableResult(req));
    }

    /**
     * 通过id批量查询
     * @param ids
     */
    @ApiOperation(value = "通过id批量查询")
    @PostMapping("/queryListById")
    @CrmLog
    public Result<List<SfaHelpDefenseRespVo>> queryListById(@RequestBody List<String> ids) {
        return Result.ok(sfaHelpDefenseService.queryListById(ids));
    }
}
