package com.biz.crm.helpdefense.controller;

import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.helpdefense.service.ISfaHelpDefenseDetailService;
import com.biz.crm.nebular.sfa.helpdefense.req.SfaHelpDefenseDetailReqVo;
import com.biz.crm.nebular.sfa.helpdefense.resp.SfaHelpDefenseDetailRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 协防执行明细;
 *
 * @author lf
 * @date 2021-01-05 15:45:45
 */
@Slf4j
@RestController
@RequestMapping("/sfahelpdefensedetail")
@Api(tags = "协防执行明细;")
public class SfaHelpDefenseDetailController {
    @Autowired
    private ISfaHelpDefenseDetailService sfaHelpDefenseDetailService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaHelpDefenseDetailRespVo>> list(@RequestBody SfaHelpDefenseDetailReqVo sfaHelpDefenseDetailReqVo) {
        PageResult<SfaHelpDefenseDetailRespVo> result=sfaHelpDefenseDetailService.findList(sfaHelpDefenseDetailReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaHelpDefenseDetailRespVo> query(@RequestBody SfaHelpDefenseDetailReqVo sfaHelpDefenseDetailReqVo) {
        SfaHelpDefenseDetailRespVo respVo=sfaHelpDefenseDetailService.query(sfaHelpDefenseDetailReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @Deprecated
    @CrmAPIDiscard
    @CrmLog
    public Result save(@RequestBody SfaHelpDefenseDetailReqVo sfaHelpDefenseDetailReqVo) {
        sfaHelpDefenseDetailService.save(sfaHelpDefenseDetailReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaHelpDefenseDetailReqVo sfaHelpDefenseDetailReqVo) {
        sfaHelpDefenseDetailService.update(sfaHelpDefenseDetailReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaHelpDefenseDetailReqVo sfaHelpDefenseDetailReqVo) {
        sfaHelpDefenseDetailService.deleteBatch(sfaHelpDefenseDetailReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaHelpDefenseDetailReqVo sfaHelpDefenseDetailReqVo) {
        sfaHelpDefenseDetailService.enableBatch(sfaHelpDefenseDetailReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaHelpDefenseDetailReqVo sfaHelpDefenseDetailReqVo) {
        sfaHelpDefenseDetailService.disableBatch(sfaHelpDefenseDetailReqVo);
        return Result.ok("禁用成功");
    }
}
