package com.biz.crm.helpdefense.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.helpdefense.service.ISfaVisitHelpDefenseService;
import com.biz.crm.nebular.sfa.helpdefense.req.SfaVisitHelpDefenseReqVo;
import com.biz.crm.nebular.sfa.helpdefense.resp.SfaVisitHelpDefenseRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 拜访-协防执行;
 *
 * @author lf
 * @date 2021-01-11 15:42:32
 */
@Slf4j
@RestController
@RequestMapping("/sfaVisitHelpDefenseController")
@Api(tags = "拜访-协防执行;")
public class SfaVisitHelpDefenseController {
    @Autowired
    private ISfaVisitHelpDefenseService sfaVisitHelpDefenseService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaVisitHelpDefenseRespVo>> list(@RequestBody SfaVisitHelpDefenseReqVo sfaVisitHelpDefenseReqVo) {
        PageResult<SfaVisitHelpDefenseRespVo> result=sfaVisitHelpDefenseService.findList(sfaVisitHelpDefenseReqVo);
        return Result.ok(result);
    }

    /**
     * 列表
     */
    @ApiOperation(value = "查询协防明细报表")
    @PostMapping("/findVisitHelpDefenseReport")
    @CrmLog
    public Result<PageResult<SfaVisitHelpDefenseRespVo>> findVisitHelpDefenseReport(@RequestBody SfaVisitHelpDefenseReqVo sfaVisitHelpDefenseReqVo) {
        PageResult<SfaVisitHelpDefenseRespVo> result=sfaVisitHelpDefenseService.findVisitHelpDefenseReport(sfaVisitHelpDefenseReqVo);
        return Result.ok(result);
    }

    /**
     * 查询协防报表详细信息
     * @param id
     * @return
     */
    @CrmLog
    @GetMapping("queryVisitHelpDefenseReportDetail")
    @ApiOperation(value = "查询协防报表详细信息")
    public Result<SfaVisitHelpDefenseRespVo> queryVisitHelpDefenseReportDetail(String id){
        SfaVisitHelpDefenseRespVo respVo = sfaVisitHelpDefenseService.queryVisitHelpDefenseReportDetail(id);
        return Result.ok(respVo);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaVisitHelpDefenseRespVo> query(@RequestBody SfaVisitHelpDefenseReqVo sfaVisitHelpDefenseReqVo) {
        SfaVisitHelpDefenseRespVo respVo=sfaVisitHelpDefenseService.query(sfaVisitHelpDefenseReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaVisitHelpDefenseReqVo sfaVisitHelpDefenseReqVo) {
        sfaVisitHelpDefenseService.save(sfaVisitHelpDefenseReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaVisitHelpDefenseReqVo sfaVisitHelpDefenseReqVo) {
        sfaVisitHelpDefenseService.update(sfaVisitHelpDefenseReqVo);
        return Result.ok("修改成功");
    }
}
