package com.biz.crm.helpdefense.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.helpdefense.model.SfaVisitHelpDefenseEntity;
import com.biz.crm.nebular.sfa.helpdefense.req.SfaVisitHelpDefenseReqVo;
import com.biz.crm.nebular.sfa.helpdefense.resp.SfaVisitHelpDefenseRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 拜访-协防执行;
 * 
 * @author lf
 * @date 2021-01-11 15:42:32
 */
public interface SfaVisitHelpDefenseMapper extends BaseMapper<SfaVisitHelpDefenseEntity> {
    /**
     * 列表
     * @param page
     * @param sfaVisitHelpDefenseReqVo
     * @return
     */
    List<SfaVisitHelpDefenseRespVo> findList(Page<SfaVisitHelpDefenseRespVo> page, @Param("vo") SfaVisitHelpDefenseReqVo sfaVisitHelpDefenseReqVo);

    /**
     * 查询报表sql
     * @param page
     * @param sfaVisitHelpDefenseReqVo
     * @return
     */
    List<SfaVisitHelpDefenseRespVo> findReportList(Page<SfaVisitHelpDefenseRespVo> page, @Param("vo") SfaVisitHelpDefenseReqVo sfaVisitHelpDefenseReqVo);

    /**
     * 查询拜访-协防执行列表
     * @param page
     * @param sfaVisitHelpDefenseReqVo
     * @return
     */
    List<SfaVisitHelpDefenseRespVo> findVisitHelpDefenseList(Page<SfaVisitHelpDefenseRespVo> page, @Param("vo") SfaVisitHelpDefenseReqVo sfaVisitHelpDefenseReqVo);

    /**
     * 查询协防进度
     * @param reqVo
     * @return
     */
    List<SfaVisitHelpDefenseRespVo> findHelpDefenseSchedule(@Param("vo")SfaVisitHelpDefenseReqVo reqVo);

}
