package com.biz.crm.helpdefense.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 协访计划明细;实体类
 *
 * @author lf
 * @date 2021-01-05 15:45:45
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_help_defense_detail")
@CrmTable(name = "sfa_help_defense_detail", tableNote = "协访计划明细;")
public class SfaHelpDefenseDetailEntity extends CrmExtTenEntity<SfaHelpDefenseDetailEntity> {

    /**
     * 协访主键id
     */
    @CrmColumn(name = "help_defense_id", length = 40, note = "协防计划ID")
    private String helpDefenseId;

    /**
     * 被协访人员账号
     */
    @CrmColumn(name = "cover_help_user_name", length = 50, note = "被协访人员账号")
    private String coverHelpUserName;

    /**
     * 被协访人员姓名
     */
    @CrmColumn(name = "cover_help_real_name", length = 50, note = "被协访人员姓名")
    private String coverHelpRealName;

    /**
     * 被协访组织编码
     */
    @CrmColumn(name = "cover_help_org_code", length = 50, note = "被协访组织编码")
    private String coverHelpOrgCode;

    /**
     * 被协访组织名称
     */
    @CrmColumn(name = "cover_help_org_name", length = 50, note = "被协访组织名称")
    private String coverHelpOrgName;

    /**
     * 被协访职位编码
     */
    @CrmColumn(name = "cover_help_pos_code", length = 50, note = "被协访职位编码")
    private String coverHelpPosCode;

    /**
     * 被协访职位名称
     */
    @CrmColumn(name = "cover_help_pos_name", length = 50, note = "被协访职位名称")
    private String coverHelpPosName;

    /**
     * 网点id
     */
    @CrmColumn(name = "client_id", length = 40, note = "网点id")
    private String clientId;

    /**
     * 网点编码
     */
    @CrmColumn(name = "client_code", length = 32, note = "网点编码")
    private String clientCode;

    /**
     * 网点名称
     */
    @CrmColumn(name = "client_name", length = 32, note = "网点名称")
    private String clientName;

    /**
     * 网点类型
     */
    @CrmColumn(name = "client_type", length = 32, note = "网点类型")
    private String clientType;

    /**
     * 网点地址
     */
    @CrmColumn(name = "client_address", length = 255, note = "网点地址")
    private String clientAddress;

    /**
     * 网点联系人
     */
    @CrmColumn(name = "client_contacts", length = 50, note = "网点联系人")
    private String clientContacts;

    /**
     * 网点图片
     */
    @CrmColumn(name = "client_photo", length = 255, note = "网点图片")
    private String clientPhoto;

    /**
     * 网点电话
     */
    @CrmColumn(name = "client_phone", length = 32, note = "网点电话")
    private String clientPhone;

    /**
     * 经度
     */
    @CrmColumn(name = "longitude", mysqlType = "decimal(32,8)", oracleType = "NUMBER(32,8)", note = "经度")
    private BigDecimal longitude;

    /**
     * 纬度
     */
    @CrmColumn(name = "latitude", mysqlType = "decimal(32,8)", oracleType = "NUMBER(32,8)", note = "纬度")
    private BigDecimal latitude;

    /**
     * 协访状态(0-待协访,1-已完成,2-已过期)
     */
    @CrmColumn(name = "help_defense_status", length = 32, note = "协访状态(0-待协访,1-已完成,2-已过期)")
    private String helpDefenseStatus;


}
