package com.biz.crm.helpdefense.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 拜访-协防执行;实体类
 *
 * @author lf
 * @date 2021-01-11 15:42:32
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_visit_help_defense")
@CrmTable(name = "sfa_visit_help_defense", tableNote = "拜访-协防执行")
public class SfaVisitHelpDefenseEntity extends CrmExtTenEntity<SfaVisitHelpDefenseEntity> {

    /**
     * 人员账号
     */
    @CrmColumn(name = "user_name", length = 50, note = "人员账号")
    private String userName;

    /**
     * 人员姓名
     */
    @CrmColumn(name = "real_name", length = 50, note = "人员姓名")
    private String realName;

    /**
     * 组织编码
     */
    @CrmColumn(name = "org_code", length = 50, note = "组织编码")
    private String orgCode;

    /**
     * 组织名称
     */
    @CrmColumn(name = "org_name", length = 50, note = "组织名称")
    private String orgName;

    /**
     * 职位编码
     */
    @CrmColumn(name = "pos_code", length = 50, note = "职位编码")
    private String posCode;

    /**
     * 职位名称
     重点问题记录     */
    @CrmColumn(name = "pos_name", length = 50, note = "职位名称")
    private String posName;

    /**
     * 协防日期
     */
    @CrmColumn(name = "defense_date", length = 32, note = "协防日期")
    private String defenseDate;

    /**
     * 协防明细id
     */
    @CrmColumn(name = "help_defense_detail_id", length = 32, note = "协防明细id")
    private String helpDefenseDetailId;

    /**
     * 协防状态(1-协防中,2-已完成)
     */
    @CrmColumn(name = "help_defense_status", length = 32, note = "协防状态(1-协防中,2-已完成)")
    private String helpDefenseStatus;

    /**
     * 客户id;客户id
     */
    @CrmColumn(name = "client_id", length = 40, note = "客户id;客户id")
    private String clientId;

    /**
     * 客户编码;协防客户编码
     */
    @CrmColumn(name = "client_code", length = 60, note = "客户编码;协防客户编码")
    private String clientCode;

    /**
     * 客户名称;协访客户名称
     */
    @CrmColumn(name = "client_name", length = 200, note = "客户名称;协访客户名称")
    private String clientName;

    /**
     * 客户类型;协访客户类型
     */
    @CrmColumn(name = "client_type", length = 32, note = "客户类型;协访客户类型")
    private String clientType;

    /**
     * 客户电话 客户电话
     */
    @CrmColumn(name = "client_phone", length = 32, note = "客户电话 客户电话")
    private String clientPhone;

    /**
     * 客户地址;客户地址
     */
    @CrmColumn(name = "client_address", length = 512, note = "客户地址;客户地址")
    private String clientAddress;

    /**
     * 协防总结
     */
    @CrmColumn(name = "help_defense_summary", length = 200, note = "协防总结")
    private String helpDefenseSummary;

    /**
     * 重点问题记录
     */
    @CrmColumn(name = "key_questions", mysqlType = "text", oracleType = "CLOB", note = "重点问题记录")
    private String keyQuestions;

    /**
     * 进店时间
     */
    @CrmColumn(name = "in_store", length = 32, note = "进店时间")
    private String inStore;

    /**
     * 进店地址
     */
    @CrmColumn(name = "in_store_address", length = 32, note = "进店地址")
    private String inStoreAddress;

    /**
     * 进店地址经度;进店地址协访客户经度
     */
    @CrmColumn(name = "in_store_longitude", mysqlType = "decimal(12,8)", oracleType = "NUMBER(12,8)", note = "进店地址经度;进店地址协访客户经度")
    private BigDecimal inStoreLongitude;

    /**
     * 进店地址纬度;进店地址协访客户纬度
     */
    @CrmColumn(name = "in_store_latitude", mysqlType = "decimal(12,8)", oracleType = "NUMBER(12,8)", note = "进店地址纬度;进店地址协访客户纬度")
    private BigDecimal inStoreLatitude;

    /**
     * 离店时间
     */
    @CrmColumn(name = "out_store", length = 32, note = "离店时间")
    private String outStore;

    /**
     * 离店地址
     */
    @CrmColumn(name = "out_store_address", length = 32, note = "离店地址")
    private String outStoreAddress;

    /**
     * 离店地址经度;进店地址协访客户经度
     */
    @CrmColumn(name = "out_store_longitude", mysqlType = "decimal(12,8)", oracleType = "NUMBER(12,8)", note = "离店地址经度;进店地址协访客户经度")
    private BigDecimal outStoreLongitude;

    /**
     * 离店地址纬度;进店地址协访客户纬度
     */
    @CrmColumn(name = "out_store_latitude", mysqlType = "decimal(12,8)", oracleType = "NUMBER(12,8)", note = "离店地址纬度;进店地址协访客户纬度")
    private BigDecimal outStoreLatitude;

}
