package com.biz.crm.helpdefense.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.helpdefense.model.SfaVisitHelpDefenseEntity;
import com.biz.crm.nebular.sfa.helpdefense.resp.step.LoadHelpDefenseExecutionInfoRespVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaVisitRoleDirectoryRespVo;
import com.biz.crm.nebular.sfa.helpdefense.req.*;
import com.biz.crm.nebular.sfa.helpdefense.resp.FindHelpDefenseScheduleRespVo;
import com.biz.crm.nebular.sfa.helpdefense.resp.SfaVisitHelpDefenseRespVo;

import java.util.List;

/**
 * 拜访-协防执行;接口
 *
 * @author lf
 * @date 2021-01-11 15:42:32
 */
public interface ISfaVisitHelpDefenseService extends IService<SfaVisitHelpDefenseEntity> {

    /**
     * 列表
     * @param sfaVisitHelpDefenseReqVo
     * @return PageResult<SfaVisitHelpDefenseRespVo>
     */
    PageResult<SfaVisitHelpDefenseRespVo> findList(SfaVisitHelpDefenseReqVo sfaVisitHelpDefenseReqVo);

    /**
     * 查询协防明细报表
     * @param sfaVisitHelpDefenseReqVo
     * @return
     */
    PageResult<SfaVisitHelpDefenseRespVo> findVisitHelpDefenseReport(SfaVisitHelpDefenseReqVo sfaVisitHelpDefenseReqVo);

    /**
     * 查看协防报表详细信息
     * @param id
     * @return
     */
    SfaVisitHelpDefenseRespVo queryVisitHelpDefenseReportDetail(String id);

    /**
     * 查询拜访-协防执行列表
     * @param findVisitHelpDefenseListReqVo
     * @return
     */
    PageResult<SfaVisitHelpDefenseRespVo> findVisitHelpDefenseList(FindVisitHelpDefenseListReqVo findVisitHelpDefenseListReqVo);

    /**
     * 查询协防进度
     * @param findHelpDefenseScheduleVo
     * @return
     */
    FindHelpDefenseScheduleRespVo findHelpDefenseSchedule(FindHelpDefenseScheduleReqVo findHelpDefenseScheduleVo);

    /**
     * 协防-进店打卡
     * @param helpDefenseInStoreReqVo
     * @return
     */
    String helpDefenseInStore(HelpDefenseInStoreReqVo helpDefenseInStoreReqVo);

    /**
     * 协防-查询协防步骤列表
     * @param id
     * @return
     */
    List<SfaVisitRoleDirectoryRespVo> findHelpDefenseROleDirectory(String id);

    /**
     * 加载协访任务执行信息
     * @param id
     * @return
     */
    LoadHelpDefenseExecutionInfoRespVo loadHelpDefenseExecutionInfo(String id);


    /**
     * 协防-离店打卡
     * @param reqVo
     */
    void helpDefenseOutStore(SfaVisitHelpDefenseReqVo reqVo);

    /**
     * 协防-步骤协防
     * @param reqVo
     */
    void saveHelpDefenseDetail(SfaVisitHelpDefenseDetailReqVo reqVo);

    /**
     * 协防-保存协防总结
     * @param reqVo
     */
    void saveHelpDefenseSummary(SfaVisitHelpDefenseReqVo reqVo);

    /**
     * 协防-查询协防详细信息
     * @param id
     * @return
     */
    SfaVisitHelpDefenseRespVo queryHelpDefenseDetail(String id);
    /**
     * 查询
     * @param sfaVisitHelpDefenseReqVo
     * @return SfaVisitHelpDefenseRespVo
     */
    SfaVisitHelpDefenseRespVo query(SfaVisitHelpDefenseReqVo sfaVisitHelpDefenseReqVo);

    /**
     * 新增
     * @param sfaVisitHelpDefenseReqVo
     * @return
     */
    void save(SfaVisitHelpDefenseReqVo sfaVisitHelpDefenseReqVo);

    /**
     * 更新
     * @param sfaVisitHelpDefenseReqVo
     * @return
     */
    void update(SfaVisitHelpDefenseReqVo sfaVisitHelpDefenseReqVo);
}

