package com.biz.crm.helpdefense.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.base.SfaClientHelper;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.IntegralEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.helpdefense.mapper.SfaHelpDefenseMapper;
import com.biz.crm.helpdefense.model.SfaHelpDefenseDetailEntity;
import com.biz.crm.helpdefense.model.SfaHelpDefenseEntity;
import com.biz.crm.helpdefense.service.ISfaHelpDefenseDetailService;
import com.biz.crm.helpdefense.service.ISfaHelpDefenseService;
import com.biz.crm.integral.controller.SfaIntegralSaveUtil;
import com.biz.crm.integral.req.SfaIntegralDetailAddReq;
import com.biz.crm.moblie.controller.visit.req.GetVisitListReq;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.sfa.helpdefense.SfaHelpDefenseDto;
import com.biz.crm.nebular.sfa.helpdefense.req.SfaHelpDefenseReqVo;
import com.biz.crm.nebular.sfa.helpdefense.resp.SfaHelpDefenseDetailRespVo;
import com.biz.crm.nebular.sfa.helpdefense.resp.SfaHelpDefenseRespVo;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.*;
import com.biz.crm.visitinfo.mapper.SfaVisitPlanInfoMapper;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitinfo.service.impl.SfaVisitPlanInfoServiceEsImpl;
import com.biz.crm.visitnote.service.ISfaVisitPlanService;
import com.biz.crm.visitnote.service.component.resolver.SfaVisitPlanResolver;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 协访执行;接口实现
 *
 * @author lf
 * @date 2021-01-05 15:45:45
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "SfaHelpDefenseServiceExpandImpl")
@Transactional
public class SfaHelpDefenseServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaHelpDefenseMapper, SfaHelpDefenseEntity> implements ISfaHelpDefenseService {

    @Resource
    private SfaHelpDefenseMapper sfaHelpDefenseMapper;
    @Resource
    private ISfaHelpDefenseDetailService sfaHelpDefenseDetailService;
    @Resource
    private SfaVisitPlanInfoMapper sfaVisitPlanInfoMapper;
    @Resource
    private ISfaVisitPlanInfoService sfaVisitPlanInfoService;
    @Resource
    private ISfaVisitPlanService sfaVisitPlanService;

    @Resource
    private RedisService redisService;

    @Resource
    private SfaVisitPlanInfoServiceEsImpl sfaVisitPlanInfoServiceEsImpl;

    /**
     * 列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaHelpDefenseRespVo> findList(SfaHelpDefenseReqVo reqVo) {
        Page<SfaHelpDefenseRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaHelpDefenseRespVo> list = sfaHelpDefenseMapper.findList(page, reqVo);
        return PageResult.<SfaHelpDefenseRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询协访计划详情信息
     * @param reqVo
     * @return
     */
    @Override
    public SfaHelpDefenseRespVo findSfaHelpDefenseDetail(SfaHelpDefenseReqVo reqVo) {
        SfaHelpDefenseRespVo respVo = null;
        AssertUtils.isNotEmpty(reqVo.getHelpDefenseDate(),"协访日期为空");
        if (!StringUtils.isNotEmpty(reqVo.getHelpUserName())){
            UserRedis userRedis = UserUtils.getUser();
            reqVo.setHelpUserName(userRedis.getUsername());
            reqVo.setHelpPosCode(userRedis.getPoscode());
        }
        SfaHelpDefenseEntity sfaHelpDefenseEntity = this.lambdaQuery()
                .eq(SfaHelpDefenseEntity::getHelpUserName, reqVo.getHelpUserName())
                .eq(SfaHelpDefenseEntity::getHelpPosCode,reqVo.getHelpPosCode())
                .eq(SfaHelpDefenseEntity::getHelpDefenseDate,reqVo.getHelpDefenseDate()).one();
        if (sfaHelpDefenseEntity == null) {
            return respVo;
        }
        respVo = CrmBeanUtil.copy(sfaHelpDefenseEntity, SfaHelpDefenseRespVo.class);
        this.getSfaHelpDefenseDetailList(respVo);
        return respVo;
    }

    /**
     * 通过主键id查询详情
     *
     * @param id
     * @return
     */
    @Override
    public SfaHelpDefenseRespVo queryDetailById(String id) {
        AssertUtils.isNotEmpty(id, "主键id不能为空");
        SfaHelpDefenseEntity sfaHelpDefenseEntity = this.lambdaQuery()
                .eq(SfaHelpDefenseEntity::getId, id).one();
        if (sfaHelpDefenseEntity == null) {
            throw new BusinessException("查询数据信息为空");
        }
        SfaHelpDefenseRespVo sfaHelpDefenseRespVo = CrmBeanUtil.copy(sfaHelpDefenseEntity, SfaHelpDefenseRespVo.class);
        this.getSfaHelpDefenseDetailList(sfaHelpDefenseRespVo);
        return sfaHelpDefenseRespVo;
    }

    /**
     * 查询协访明细信息
     * @param sfaHelpDefenseRespVo
     */
    private void getSfaHelpDefenseDetailList(SfaHelpDefenseRespVo sfaHelpDefenseRespVo){
        List<SfaVisitPlanInfoEntity> sfaVisitPlanInfoEntityList = this.sfaVisitPlanInfoServiceEsImpl.findByVisitPlanCode(sfaHelpDefenseRespVo.getId());
//        List<SfaHelpDefenseDetailEntity> sfaHelpDefenseDetailEntityList = sfaHelpDefenseDetailService.lambdaQuery()
//                .eq(SfaHelpDefenseDetailEntity::getHelpDefenseId, sfaHelpDefenseRespVo.getId())
//                .list();
        List<SfaHelpDefenseDetailRespVo> sfaHelpDefenseDetailRespVos = sfaVisitPlanInfoEntityList.stream().map(v -> {
            SfaHelpDefenseDetailRespVo temp = CrmBeanUtil.copy(v, SfaHelpDefenseDetailRespVo.class);
            temp.setHelpDefenseId(sfaHelpDefenseRespVo.getId());
            temp.setHelpDefenseStatus(v.getVisitStatus());
            temp.setHelpDefenseStatusDesc(v.getVisitStatusName());
            return temp;
        }).collect(Collectors.toList());
//        List<SfaHelpDefenseDetailRespVo> sfaHelpDefenseDetailRespVos = CrmBeanUtil.copyList(sfaVisitPlanInfoEntityList, SfaHelpDefenseDetailRespVo.class);
        Map<String, List<SfaHelpDefenseDetailRespVo>> detailMap = sfaHelpDefenseDetailRespVos.stream().collect(Collectors.groupingBy(data -> fetchGroupKey(data)));
        List<SfaHelpDefenseDto> sfaHelpDefenseDtos = new ArrayList<>();
        for (Map.Entry<String, List<SfaHelpDefenseDetailRespVo>> map : detailMap.entrySet()) {
            SfaHelpDefenseDetailRespVo sfaHelpDefenseDetailRespVo = map.getValue().get(0);
            SfaHelpDefenseDto sfaHelpDefenseDto = CrmBeanUtil.copy(sfaHelpDefenseDetailRespVo, SfaHelpDefenseDto.class);
            map.getValue().forEach(data->{
                data.setHelpDefenseStatusDesc(SfaVisitEnum.HelpVisitStatus.GETMAP.get(data.getHelpDefenseStatus()));
                data.setClientTypeDesc(SfaVisitEnum.ClientType.GETMAP.get(data.getClientType()));
            });
            sfaHelpDefenseDto.setSfaHelpDefenseDetailList(map.getValue());
            sfaHelpDefenseDtos.add(sfaHelpDefenseDto);
        }
        sfaHelpDefenseRespVo.setSfaHelpDefenseList(sfaHelpDefenseDtos);
    }

    private void buildClientCodes(List<SfaHelpDefenseDto> sfaHelpDefenseList, List<String> customerCodes, List<String> terminalCodes){
        if(null == sfaHelpDefenseList){
            return;
        }
        sfaHelpDefenseList.forEach(data -> {
            List<SfaHelpDefenseDetailRespVo> sfaHelpDefenseDetailList = data.getSfaHelpDefenseDetailList();
            if(null == sfaHelpDefenseDetailList){
                return;
            }
            sfaHelpDefenseDetailList.forEach(da -> {
                if(SfaVisitEnum.ClientType.TERMINAL.getVal().equals(da.getClientType())){
                    terminalCodes.add(da.getClientCode());
                }else {
                    customerCodes.add(da.getClientCode());
                }
            });
        });
    }
    /**
     * 新增协访计划
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaHelpDefenseReqVo reqVo) {
        this.checkParam(reqVo);
        SfaHelpDefenseEntity sfaHelpDefenseEntityTemp = this.lambdaQuery()
                .eq(SfaHelpDefenseEntity::getHelpUserName, reqVo.getHelpUserName())
                .eq(SfaHelpDefenseEntity::getHelpPosCode,reqVo.getHelpPosCode())
                .eq(SfaHelpDefenseEntity::getHelpDefenseDate,reqVo.getHelpDefenseDate()).one();
        boolean isAdd = false;
        if(null == sfaHelpDefenseEntityTemp){
            sfaHelpDefenseEntityTemp = CrmBeanUtil.copy(reqVo, SfaHelpDefenseEntity.class);
            isAdd = true;
        }else{
            String id = sfaHelpDefenseEntityTemp.getId();
            CrmBeanUtil.copyPropertiesIgnoreEmpty(reqVo, sfaHelpDefenseEntityTemp);
            sfaHelpDefenseEntityTemp.setId(id);
        }
        SfaHelpDefenseEntity sfaHelpDefenseEntity = sfaHelpDefenseEntityTemp;
        this.saveOrUpdate(sfaHelpDefenseEntity);
        Set<String> coverHelpRealName = Sets.newHashSet();

        Map<String, Map<String, SfaVisitPlanInfoEntity>> daysPlanInfo = this.buildHelpVisitPlan(reqVo, sfaHelpDefenseEntity, coverHelpRealName);

        sfaHelpDefenseEntity.setCoverHelpRealName(coverHelpRealName.stream().collect(Collectors.joining(",")));
        this.updateById(sfaHelpDefenseEntity);
        this.sfaVisitPlanService.saveVisitPlanInfoToRedisAndEs(daysPlanInfo);
        //新增积分
        if(isAdd){
            SfaIntegralDetailAddReq integralDetailAddReq = new SfaIntegralDetailAddReq();
            integralDetailAddReq.setBizId(sfaHelpDefenseEntityTemp.getId());
            integralDetailAddReq.setIntegralTaskType(IntegralEnum.taskType.PLANING_HELP_DEFENSE.getValue());
            integralDetailAddReq.setPosCode(reqVo.getCreatePosCode());
            integralDetailAddReq.setUserName(reqVo.getCreateName());
            integralDetailAddReq.setExtParam(null);
            //新增积分
            SfaIntegralSaveUtil.saveIntegralDetail(integralDetailAddReq);
        }
    }



    private Map<String, Map<String, SfaVisitPlanInfoEntity>> buildHelpVisitPlan(SfaHelpDefenseReqVo reqVo, SfaHelpDefenseEntity sfaHelpDefenseEntity, Set<String> coverHelpRealName){
        Map<String, Map<String, SfaVisitPlanInfoEntity>> daysPlanInfo = Maps.newHashMap();
        List<SfaVisitPlanInfoEntity> planInfoEntities = Lists.newArrayList();
        List<SfaHelpDefenseDto> sfaHelpDefenseList = reqVo.getSfaHelpDefenseList();
        List<String> customerCodes = Lists.newArrayList();
        List<String> terminalCodes = Lists.newArrayList();
        this.buildClientCodes(sfaHelpDefenseList, customerCodes, terminalCodes);
        Map<String, SfaClientData> clientDataMap = SfaClientHelper.loadClientDataMap(customerCodes, terminalCodes);
        sfaHelpDefenseList.forEach(data -> {
//            reqVo.setCoverHelpPosCode(data.getCoverHelpPosCode());
//            Integer count = sfaHelpDefenseMapper.selectSfaHelpDefenseCountByCondition(reqVo);
//            if (count>0){
//                throw new BusinessException("已存在协访日期内的协访数据信息");
//            }
            List<SfaHelpDefenseDetailRespVo> sfaHelpDefenseDetailList = data.getSfaHelpDefenseDetailList();

            sfaHelpDefenseDetailList.forEach(da -> {
                String visitDate = reqVo.getHelpDefenseDate()
                        , visitUserName = reqVo.getHelpUserName()
                        , visitPosCode = reqVo.getHelpPosCode()
                        , visitBigType = SfaVisitEnum.VisitBigType.HELP_VISIT.getVal();
                String redisHash = SfaVisitPlanInfoEntity.getInstance().redisHash(visitDate, visitUserName, visitPosCode,visitBigType).toString();
                Map<String, SfaVisitPlanInfoEntity> visitPlanInfoMap = daysPlanInfo.get(redisHash);
                if(null == visitPlanInfoMap){
                    visitPlanInfoMap = Maps.newHashMap();
                }
                SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey
                        = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitDate, visitUserName, visitPosCode, visitBigType
                        , da.getClientType(), da.getClientCode());
                SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = visitPlanInfoMap.get(visitRedisHashKey.getRedisHashKey());

                if(null == sfaVisitPlanInfoEntity){
                    sfaVisitPlanInfoEntity = CrmBeanUtil.copy(da, SfaVisitPlanInfoEntity.class);
                    this.buildSfaVisitPlanInfoEntity(sfaVisitPlanInfoEntity, sfaHelpDefenseEntity, data);
                    SfaClientData clientData = clientDataMap.get(da.getClientType() + da.getClientCode());
                    SfaVisitPlanInfoEntity.copyClientData(sfaVisitPlanInfoEntity, clientData);

                    planInfoEntities.add(sfaVisitPlanInfoEntity);
                }else {// 同一个客户协访多个人
                    sfaVisitPlanInfoEntity.setCoverHelpOrgCode(new StringJoiner(",")
                            .add(sfaVisitPlanInfoEntity.getCoverHelpOrgCode()).add(data.getCoverHelpOrgCode()).toString());

                    sfaVisitPlanInfoEntity.setCoverHelpOrgName(new StringJoiner(",")
                            .add(sfaVisitPlanInfoEntity.getCoverHelpOrgName()).add(data.getCoverHelpOrgName()).toString());

                    sfaVisitPlanInfoEntity.setCoverHelpPosCode(new StringJoiner(",")
                            .add(sfaVisitPlanInfoEntity.getCoverHelpPosCode()).add(data.getCoverHelpPosCode()).toString());

                    sfaVisitPlanInfoEntity.setCoverHelpPosName(new StringJoiner(",")
                            .add(sfaVisitPlanInfoEntity.getCoverHelpPosName()).add(data.getCoverHelpPosName()).toString());

                    sfaVisitPlanInfoEntity.setCoverHelpRealName(new StringJoiner(",")
                            .add(sfaVisitPlanInfoEntity.getCoverHelpRealName()).add(data.getCoverHelpRealName()).toString());

                    sfaVisitPlanInfoEntity.setCoverHelpUserName(new StringJoiner(",")
                            .add(sfaVisitPlanInfoEntity.getCoverHelpUserName()).add(data.getCoverHelpUserName()).toString());
                }
                sfaVisitPlanInfoEntity.setId(UUIDGenerator.generate());
                sfaVisitPlanInfoEntity.setVisitPlanCode(sfaHelpDefenseEntity.getId());
//                sfaHelpDefenseDetailEntityList.add(sfaVisitPlanInfoEntity);
                coverHelpRealName.add(data.getCoverHelpRealName());
                visitPlanInfoMap.put(visitRedisHashKey.getRedisHashKey(), sfaVisitPlanInfoEntity);
                daysPlanInfo.put(redisHash, visitPlanInfoMap);
            });
        });
        this.injectClientInfo(planInfoEntities);
        return daysPlanInfo;
    }

    private void buildSfaVisitPlanInfoEntity(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, SfaHelpDefenseEntity sfaHelpDefenseEntity, SfaHelpDefenseDto data){

        sfaVisitPlanInfoEntity.setVisitUserName(sfaHelpDefenseEntity.getHelpUserName());
        sfaVisitPlanInfoEntity.setVisitRealName(sfaHelpDefenseEntity.getHelpRealName());
        sfaVisitPlanInfoEntity.setVisitOrgCode(sfaHelpDefenseEntity.getHelpOrgCode());
        sfaVisitPlanInfoEntity.setVisitOrgName(sfaHelpDefenseEntity.getHelpOrgName());
        sfaVisitPlanInfoEntity.setVisitPlanCode(sfaHelpDefenseEntity.getId());
        sfaVisitPlanInfoEntity.setVisitPosCode(sfaHelpDefenseEntity.getHelpPosCode());
        sfaVisitPlanInfoEntity.setVisitPosName(sfaHelpDefenseEntity.getHelpPosName());
        sfaVisitPlanInfoEntity.setVisitDate(sfaHelpDefenseEntity.getHelpDefenseDate());
        LocalDate date = LocalDate.parse(sfaHelpDefenseEntity.getHelpDefenseDate(), CrmDateUtils.yyyyMMdd);
        sfaVisitPlanInfoEntity.setVisitDateOfYearMonth(date.format(CrmDateUtils.yyyyMM));
        sfaVisitPlanInfoEntity.setVisitDateOfYear(date.format(CrmDateUtils.yyyy));
        MdmOrgRespVo mdmOrgRespVo = OrgUtil.getOrgByCode(sfaHelpDefenseEntity.getHelpPosCode());
        if(null != mdmOrgRespVo){
            sfaVisitPlanInfoEntity.setParentOrgCode(mdmOrgRespVo.getParentCode());
            sfaVisitPlanInfoEntity.setParentOrgName(mdmOrgRespVo.getParentName());
        }

        sfaVisitPlanInfoEntity.setCoverHelpOrgCode(data.getCoverHelpOrgCode());
        sfaVisitPlanInfoEntity.setCoverHelpOrgName(data.getCoverHelpOrgName());
        sfaVisitPlanInfoEntity.setCoverHelpPosCode(data.getCoverHelpPosCode());
        sfaVisitPlanInfoEntity.setCoverHelpPosName(data.getCoverHelpPosName());
        sfaVisitPlanInfoEntity.setCoverHelpRealName(data.getCoverHelpRealName());
        sfaVisitPlanInfoEntity.setCoverHelpUserName(data.getCoverHelpUserName());
        sfaVisitPlanInfoEntity.setVisitStatus(SfaVisitEnum.HelpVisitStatus.READY_HELP_DEFENSE.getVal());
        sfaVisitPlanInfoEntity.setVisitStatusName(SfaVisitEnum.HelpVisitStatus.READY_HELP_DEFENSE.getDesc());
        sfaVisitPlanInfoEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        sfaVisitPlanInfoEntity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());

        sfaVisitPlanInfoEntity.setVisitType(SfaVisitEnum.visitType.PLAN_VISIT.getVal());
        sfaVisitPlanInfoEntity.setVisitTypeName(SfaVisitEnum.visitType.PLAN_VISIT.getDesc());
        sfaVisitPlanInfoEntity.setVisitBigType( SfaVisitEnum.VisitBigType.HELP_VISIT.getVal());
        sfaVisitPlanInfoEntity.setVisitBigTypeName(SfaVisitEnum.VisitBigType.HELP_VISIT.getDesc());
        sfaVisitPlanInfoEntity.setClientTypeName(SfaVisitEnum.ClientType.GETMAP.get(sfaVisitPlanInfoEntity.getClientType()));
        SfaVisitPlanInfoEntity.buildDefEntityData(sfaVisitPlanInfoEntity);
    }
    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional
    public void update(SfaHelpDefenseReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getId(), "数据主键id为空");
        this.checkParam(reqVo);
        LocalDate now = LocalDate.now();
        LocalDate updateNow = LocalDate.parse(reqVo.getHelpDefenseDate());
        if (!updateNow.isEqual(now) && !updateNow.isAfter(now)){
            throw new BusinessException("修改的协访日期不能小于等于当前日期");
        }
        SfaHelpDefenseEntity sfaHelpDefenseEntity = this.lambdaQuery()
                .eq(SfaHelpDefenseEntity::getId, reqVo.getId()).one();
        if (sfaHelpDefenseEntity == null) {
            throw new BusinessException("查询协访数据信息为空");
        }
        sfaHelpDefenseEntity.setHelpDefenseDate(reqVo.getHelpDefenseDate());
        LocalDate helpDefenseDate = LocalDate.parse(sfaHelpDefenseEntity.getHelpDefenseDate());
        if (!helpDefenseDate.isAfter(now)){
            throw new BusinessException("不可修改当天/历史协访数据");
        }
        String id = sfaHelpDefenseEntity.getId();
        List<SfaHelpDefenseDetailEntity> sfaHelpDefenseDetailEntities = sfaHelpDefenseDetailService.lambdaQuery()
                .eq(SfaHelpDefenseDetailEntity::getHelpDefenseId,id).list();
        List<String> detailIds = sfaHelpDefenseDetailEntities.stream().map(SfaHelpDefenseDetailEntity::getId).collect(Collectors.toList());
        this.updateById(sfaHelpDefenseEntity);
        sfaHelpDefenseDetailService.removeByIds(detailIds);

        List<SfaHelpDefenseDetailEntity> sfaHelpDefenseDetailEntityList = new ArrayList<>();
        StringBuffer coverHelpRealName = new StringBuffer();
        reqVo.getSfaHelpDefenseList().forEach(data -> {
            reqVo.setCoverHelpPosCode(data.getCoverHelpPosCode());
            Integer count = sfaHelpDefenseMapper.selectSfaHelpDefenseCountByCondition(reqVo);
            if (now.isEqual(updateNow)){
                if (count>1){
                    throw new BusinessException("已存在协访日期内的协访数据信息");
                }
            }else {
                if (count>0){
                    throw new BusinessException("已存在协访日期内的协访数据信息");
                }
            }
            data.getSfaHelpDefenseDetailList().forEach(da -> {
                SfaHelpDefenseDetailEntity sfaHelpDefenseDetailEntity = CrmBeanUtil.copy(da, SfaHelpDefenseDetailEntity.class);
                sfaHelpDefenseDetailEntity.setCoverHelpOrgCode(data.getCoverHelpOrgCode());
                sfaHelpDefenseDetailEntity.setCoverHelpOrgName(data.getCoverHelpOrgName());
                sfaHelpDefenseDetailEntity.setCoverHelpPosCode(data.getCoverHelpPosCode());
                sfaHelpDefenseDetailEntity.setCoverHelpPosName(data.getCoverHelpPosName());
                sfaHelpDefenseDetailEntity.setCoverHelpRealName(data.getCoverHelpRealName());
                sfaHelpDefenseDetailEntity.setCoverHelpUserName(data.getCoverHelpUserName());
                sfaHelpDefenseDetailEntity.setHelpDefenseStatus(SfaVisitEnum.HelpVisitStatus.READY_HELP_DEFENSE.getVal());
                sfaHelpDefenseDetailEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                sfaHelpDefenseDetailEntity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                sfaHelpDefenseDetailEntity.setHelpDefenseId(id);
                sfaHelpDefenseDetailEntityList.add(sfaHelpDefenseDetailEntity);
                if(coverHelpRealName.length()==0){
                    coverHelpRealName.append(data.getCoverHelpRealName());
                }else {
                    coverHelpRealName.append(",").append(data.getCoverHelpRealName());
                }
            });
        });
        sfaHelpDefenseDetailService.saveBatch(sfaHelpDefenseDetailEntityList);
        sfaHelpDefenseEntity.setCoverHelpRealName(coverHelpRealName.toString());
        this.updateById(sfaHelpDefenseEntity);
    }
    /**
     * 注入客户信息
     * @param planInfoEntities
     */
    private void injectClientInfo(List<SfaVisitPlanInfoEntity> planInfoEntities){
        //经销商编码
        List<String> customerCodes = planInfoEntities.stream().filter(o -> {
                    return SfaVisitEnum.ClientType.DEALER.getVal().equals(o.getClientType());
                }).map(SfaVisitPlanInfoEntity :: getClientCode).collect(Collectors.toList());
        //终端编码
        List<String> terminalCodes = planInfoEntities.stream().filter(o -> {
                    return SfaVisitEnum.ClientType.TERMINAL.getVal().equals(o.getClientType());
                }).map(SfaVisitPlanInfoEntity :: getClientCode).collect(Collectors.toList());

        Map<String, SfaClientData> clientDataMap = SfaClientHelper.loadClientDataMap(customerCodes, terminalCodes);
        for (SfaVisitPlanInfoEntity data : planInfoEntities) {
            SfaClientData clientData = clientDataMap.get(data.getClientCode());
            SfaVisitPlanInfoEntity.copyClientData(data, clientData);
        }
    }

    /**
     * 查询被协访的拜访网点信息
     *
     * @param reqVo
     * @return
     */
    @Override
    public List<SfaVisitPlanInfoRespVo> findSfaVisitPlanInfoList(SfaVisitPlanInfoReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getVisitUserName(), "人员账号为空");
        AssertUtils.isNotEmpty(reqVo.getVisitPosCode(), "职位编码为空");
        AssertUtils.isNotEmpty(reqVo.getVisitDate(), "拜访日期为空");
        AssertUtils.isNotEmpty(reqVo.getClientType(),"客户类型为空");

        GetVisitListReq.MoreReq req = new GetVisitListReq.MoreReq();
        req.setVisitUserName(reqVo.getVisitUserName());
        req.setVisitPositionCode(reqVo.getVisitPosCode());
        req.setVisitDate(reqVo.getVisitDate());
        req.setClientType(reqVo.getClientType());
        req.setKeyWord(reqVo.getKeyWord());
        req.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());
        List<SfaVisitPlanInfoEntity> list = this.sfaVisitPlanInfoService.getVisitInfoListByClientType(req);
        List<SfaVisitPlanInfoRespVo> plans = list.stream().map(v -> {
            SfaVisitPlanInfoRespVo respVo = CrmBeanUtil.copy(v, SfaVisitPlanInfoRespVo.class);
//            respVo.setClientTypeDesc(ClientEnum.clientType.CUSTOMER);
            return respVo;
        }).collect(Collectors.toList());
        return plans;
    }

    @Override
    public List<SfaVisitPlanInfoRespVo> findAllSfaVisitPlanInfoList(SfaVisitPlanInfoReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getVisitUserName(), "人员账号为空");
        AssertUtils.isNotEmpty(reqVo.getVisitPosCode(), "职位编码为空");
        AssertUtils.isNotEmpty(reqVo.getVisitDate(), "拜访日期为空");
        reqVo.setVisitStatus(SfaVisitEnum.visitStatus.V1.getVal());
        List<SfaVisitPlanInfoRespVo> sfaVisitPlanInfoEntities = sfaVisitPlanInfoMapper.findAllSfaVisitPlanInfo(reqVo);
        return sfaVisitPlanInfoEntities;
    }



    /**
     * 校验参数信息
     *
     * @param reqVo
     */
    private void checkParam(SfaHelpDefenseReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getHelpOrgCode(), "协访人员组织编码为空");
        AssertUtils.isNotEmpty(reqVo.getHelpOrgName(), "协访人员组织名称为空");
        if (!StringUtils.isNotEmpty(reqVo.getHelpPosCode())){
            reqVo.setHelpPosCode(reqVo.getHelpUserName());
            reqVo.setHelpPosName(reqVo.getHelpRealName());
        }
//        AssertUtils.isNotEmpty(reqVo.getHelpPosCode(), "协访人员职位编码为空");
//        AssertUtils.isNotEmpty(reqVo.getHelpPosName(), "协访人员职位名称为空");
        AssertUtils.isNotEmpty(reqVo.getHelpUserName(), "协访人员账号为空");
        AssertUtils.isNotEmpty(reqVo.getHelpRealName(), "协访人员姓名为空");
        AssertUtils.isNotEmpty(reqVo.getHelpDefenseDate(), "协访日期为空");
        LocalDate visitDate ;
        try {
            visitDate = LocalDate.parse(reqVo.getHelpDefenseDate(), CrmDateUtils.yyyyMMdd);
        }catch (Exception e){
            throw new BusinessException("非法的协访日期格式[" + reqVo.getHelpDefenseDate() + "]", e);
        }
        LocalDate now = LocalDate.now();
        if(visitDate.compareTo(now) < 0 || (visitDate.toEpochDay() - now.toEpochDay()) >= SfaVisitPlanResolver.futureDays){
            throw new BusinessException("只能选择当天及未来" + SfaVisitPlanResolver.futureDays + "天的协访日期");
        }
        List<SfaHelpDefenseDto> sfaHelpDefenseList = reqVo.getSfaHelpDefenseList();
        if(org.springframework.util.CollectionUtils.isEmpty(sfaHelpDefenseList)){
            throw new BusinessException("被协访人员信息列表为空");
        }
        Set<String> coverHelpPosCodes = Sets.newHashSet();
        for (SfaHelpDefenseDto sfaHelpDefenseDto : sfaHelpDefenseList) {
            if (coverHelpPosCodes.contains(sfaHelpDefenseDto.getCoverHelpPosCode())){
                throw new BusinessException("存在相同被协访人员[" + sfaHelpDefenseDto.getCoverHelpPosName() + "]");
            }
            coverHelpPosCodes.add(sfaHelpDefenseDto.getCoverHelpPosCode());

            AssertUtils.isNotEmpty(sfaHelpDefenseDto.getCoverHelpOrgCode(), "被协访人员组织编码为空");
            AssertUtils.isNotEmpty(sfaHelpDefenseDto.getCoverHelpOrgName(), "被协访人员组织名称为空");
            if (!StringUtils.isNotEmpty(sfaHelpDefenseDto.getCoverHelpPosCode())){
                sfaHelpDefenseDto.setCoverHelpPosCode(sfaHelpDefenseDto.getCoverHelpUserName());
                sfaHelpDefenseDto.setCoverHelpPosName(sfaHelpDefenseDto.getCoverHelpRealName());
            }
//            AssertUtils.isNotEmpty(sfaHelpDefenseDto.getCoverHelpPosCode(), "被协访人员职位编码为空");
//            AssertUtils.isNotEmpty(sfaHelpDefenseDto.getCoverHelpPosName(), "被协访人员职位名称为空");
            AssertUtils.isNotEmpty(sfaHelpDefenseDto.getCoverHelpUserName(), "被协访人员账号为空");
            AssertUtils.isNotEmpty(sfaHelpDefenseDto.getCoverHelpRealName(), "被协访人员姓名为空");
            AssertUtils.isNotEmpty(sfaHelpDefenseDto.getSfaHelpDefenseDetailList(), "被协访客户列表为空");

            Set<String> clientCodes = Sets.newHashSet();
            List<SfaHelpDefenseDetailRespVo> sfaHelpDefenseDetailList = sfaHelpDefenseDto.getSfaHelpDefenseDetailList();
            if(org.springframework.util.CollectionUtils.isEmpty(sfaHelpDefenseDetailList)){
                throw new BusinessException("被协访人员[" + sfaHelpDefenseDto.getCoverHelpPosName() + "]网点列表为空");
            }
            sfaHelpDefenseDetailList.forEach(da -> {
                if (clientCodes.contains(da.getClientCode())){
                    throw new BusinessException("被协访人员[" + sfaHelpDefenseDto.getCoverHelpPosName() + "]存在重复的网点[" + da.getClientName() + "]");
                }
                clientCodes.add(da.getClientCode());
                AssertUtils.isNotEmpty(da.getClientCode(), "网点编码为空");
                AssertUtils.isNotEmpty(da.getClientName(), "网点名称为空");
                AssertUtils.isNotEmpty(da.getClientType(), "网点类型为空");
//                AssertUtils.isNotEmpty(da.getClientAddress(),"网点地址为空");
            });
        }



    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids,"数据主键不能为空");
        List<SfaHelpDefenseEntity> sfaHelpDefenseEntities = sfaHelpDefenseMapper.selectBatchIds(ids);
        List<String> idList = sfaHelpDefenseEntities.stream().map(SfaHelpDefenseEntity::getId).collect(Collectors.toList());
        List<SfaHelpDefenseDetailEntity> sfaHelpDefenseDetailEntityList = sfaHelpDefenseDetailService.lambdaQuery()
                .in(SfaHelpDefenseDetailEntity::getHelpDefenseId,idList).list();
        List<String> detailIdList = sfaHelpDefenseDetailEntityList.stream().map(SfaHelpDefenseDetailEntity::getId).collect(Collectors.toList());
        this.removeByIds(idList);
        sfaHelpDefenseDetailService.removeByIds(detailIdList);
    }

    /**
     * 启用
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaHelpDefenseReqVo reqVo) {
        //设置状态为启用
        List<SfaHelpDefenseEntity> sfaHelpDefenseEntities = sfaHelpDefenseMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty(sfaHelpDefenseEntities)) {
            sfaHelpDefenseEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaHelpDefenseEntities);
    }

    /**
     * 禁用
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaHelpDefenseReqVo reqVo) {
        //设置状态为禁用
        List<SfaHelpDefenseEntity> sfaHelpDefenseEntities = sfaHelpDefenseMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty(sfaHelpDefenseEntities)) {
            sfaHelpDefenseEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaHelpDefenseEntities);
    }

    @Override
    public List<SfaHelpDefenseRespVo> queryListById(List<String> ids) {
        List<SfaHelpDefenseEntity> list = this.lambdaQuery()
                .in(SfaHelpDefenseEntity::getId, ids).list();
        if (list == null) {
            throw new BusinessException("查询数据信息为空");
        }
        List<SfaHelpDefenseRespVo> sfaHelpDefenseRespVo = CrmBeanUtil.copyList(list, SfaHelpDefenseRespVo.class);
        sfaHelpDefenseRespVo.forEach(this::getSfaHelpDefenseDetailList);
        return sfaHelpDefenseRespVo;
    }

    /**
     * 协防计划删除校验
     *
     * @param id
     */
    @Override
    public void checkIsDelete(String id, String coverHelpPosCode) {
        SfaHelpDefenseRespVo sfaHelpDefenseRespVo = this.queryDetailById(id);
        List<SfaHelpDefenseDto> helpDefenseList = sfaHelpDefenseRespVo.getSfaHelpDefenseList();
        if (CollectionUtil.listNotEmptyNotSizeZero(helpDefenseList)){
            Map<String, List<SfaHelpDefenseDetailRespVo>> map = helpDefenseList.stream().filter(v -> CollectionUtil.listNotEmptyNotSizeZero(v.getSfaHelpDefenseDetailList()))
                    .collect(Collectors.toMap(SfaHelpDefenseDto::getCoverHelpPosCode, SfaHelpDefenseDto::getSfaHelpDefenseDetailList));

            List<SfaHelpDefenseDetailRespVo> sfaHelpDefenseDetailRespVos = map.get(coverHelpPosCode);
            if (CollectionUtil.listNotEmptyNotSizeZero(sfaHelpDefenseDetailRespVos)){
                List<String> clientList = sfaHelpDefenseDetailRespVos.stream().filter(o -> !o.getHelpDefenseStatus().equals(SfaVisitEnum.visitStatus.V1.getVal()))
                        .map(SfaHelpDefenseDetailRespVo::getClientCode)
                        .collect(Collectors.toList());
                if (CollectionUtil.listNotEmptyNotSizeZero(clientList)){
                    throw new BusinessException("终端{" +clientList.stream().collect(Collectors.joining("、")) + "}未在未执行状态，不能删除！");
                }
            }
//            ArrayList<String> list = Lists.newArrayList();
//            map.values().forEach(v -> {
//                List<String> collect = v.stream().filter(o -> !o.getHelpDefenseStatus().equals(SfaVisitEnum.visitStatus.V1.getVal()))
//                        .map(SfaHelpDefenseDetailRespVo::getClientCode)
//                        .collect(Collectors.toList());
//                list.addAll(collect);
//            });
//            if (CollectionUtil.listNotEmptyNotSizeZero(list)){
//                throw new BusinessException("存在未在未执行状态的终端！");
//            }
        }
    }


    /**
     * 设置唯一key
     *
     * @param respVo
     * @return
     */
    private String fetchGroupKey(SfaHelpDefenseDetailRespVo respVo) {
        return respVo.getCoverHelpUserName() + "_" + respVo.getCoverHelpPosCode() + "_" + respVo.getCoverHelpOrgCode();
    }
}
