package com.biz.crm.integral.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 积分明细——实体
 * @author YuanZiJian
 * @date 2021/1/12 9:55
 * @version: V1.0
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_integral_detail")
@CrmTable(name = "sfa_integral_detail", tableNote = "积分明细", indexes = {
        @Index(name = "sfa_integral_detail_index1", columnList = "biz_id", unique = true),
        @Index(name = "sfa_integral_detail_index2", columnList = "user_name"),
        @Index(name = "sfa_integral_detail_index3", columnList = "pos_code"),
        @Index(name = "sfa_integral_detail_index4", columnList = "integral_task_type")
})
public class SfaIntegralDetailEntity extends CrmExtTenEntity {

    @CrmColumn(name = "biz_id", length = 128, note = "业务id")
    private String bizId;

    /**
     * 所属积分规则编码
     */
    @CrmColumn(name = "integral_rule_code", length = 64, note = "所属积分规则编码")
    private  String integralRuleCode;
    /**
     * 所属积分规则Id
     */
    @CrmColumn(name = "integral_rule_id", length = 32, note = "所属积分规则Id")
    private String integralRuleId;
    /**
     * 所属积分规则名称
     */
    @CrmColumn(name = "integral_rule_name", length = 32, note = "所属积分规则名称")
    private String integralRuleName;
    /**
     * 积分数
     */
    @CrmColumn(name = "integral_num", mysqlType = "int(10)", oracleType = "NUMBER(10,0)", note = "积分数")
    private Integer integralNum;
    /**
     * 所属计算规则类型
     */
    @CrmColumn(name = "integral_task_type", length = 32, note = "所属计算规则类型")
    private String integralTaskType;
    /**
     * 人员编码（添加记录的账号)
     */
    @CrmColumn(name = "user_name", length = 64, note = "人员编码（添加记录的账号)")
    private String userName;
    /**
     * 人员名字（添加记录的人名）
     */
    @CrmColumn(name = "full_name", length = 64, note = "人员名字（添加记录的人名）")
    private String fullName;
    /**
     * 职位等级编码
     */
    @CrmColumn(name = "pos_code", length = 32, note = "职位等级编码")
    private String posCode;
    /**
     * 职位等级名称
     */
    @CrmColumn(name = "pos_name", length = 60, note = "职位等级名称")
    private String posName;
    /**
     * 组织编码
     */
    @CrmColumn(name = "org_code", length = 32, note = "组织编码")
    private String orgCode;
    /**
     * 组织名称
     */
    @CrmColumn(name = "org_name", length = 60, note = "组织名称")
    private String orgName;


}
