package com.biz.crm.integral.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 积分规则覆盖的角色编码和组织编码 实体
 * @author YuanZiJian
 * @date 2021/1/8 11:15
 * @version: V1.0
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_integral_range")
@CrmTable(name = "sfa_integral_range", tableNote = "积分规则覆盖的角色编码和组织编码 ",indexes = {
        @Index(name = "sfa_integral_range_index1",columnList = "code"),
        @Index(name = "sfa_integral_range_index2",columnList = "integral_rule_id")
})
public class SfaIntegralRangeEntity extends CrmExtTenEntity {

    /**
     * 所属积分规则Id
     */
    @CrmColumn(name = "integral_rule_id", length = 32, note = "所属积分规则Id")
    private String integralRuleId;

    /**
     * 组织编码
     */
    @CrmColumn(name = "code", length = 32, note = "组织编码")
    private String code;

    /**
     * 组织名称
     */
    @CrmColumn(name = "name", length = 32, note = "组织名称")
    private String name;

    /**
     * 类型：组织：org，职位：pos
     */
    @CrmColumn(name = "type", length = 32, note = "类型：组织：org，职位：pos")
    private String type;

}
