package com.biz.crm.integral.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 积分规则实体
 * @author YuanZiJian
 * @date 2021/1/8 10:27
 * @version: V1.0
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_integral_rule")
@CrmTable(name = "sfa_integral_rule", tableNote = "积分规则实体")
public class SfaIntegralRuleEntity extends CrmExtTenEntity {

    /**
     * 积分规则名称
     */
    @CrmColumn(name = "integral_rule_name", length = 32, note = "积分规则名称   ")
    private String integralRuleName;

    /**
     * 开始时间
     */
    @CrmColumn(name = "start_time", length = 32, note = "开始时间")
    private String startTime;

    /**
     * 结束时间
     */
    @CrmColumn(name = "end_time", length = 32, note = "结束时间")
    private String endTime;

    /**
     * 积分规则编码
     */
    @CrmColumn(name = "integral_rule_code", length = 64, note = "积分规则编码")
    private String integralRuleCode;
}
