package com.biz.crm.integral.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 积分任务实体
 * @author YuanZiJian
 * @date 2021/1/8 11:31
 * @version: V1.0
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_integral_task")
@CrmTable(name = "sfa_integral_task", tableNote = "积分任务实体")
public class SfaIntegralTaskEntity extends CrmExtTenEntity {
    /**
     * 所属积分规则Id
     */
    @CrmColumn(name = "integral_rule_id", length = 32, note = "所属积分规则Id")
    private String integralRuleId;

    /**
     * 积分任务类型
     */
    @CrmColumn(name = "integral_task_type", length = 32, note = "积分任务类型")
    private String integralTaskType;

    /**
     * 积分任务加积分数-任务完成奖励
     */
    @CrmColumn(name = "integral_task_reward", mysqlType = "int(10)", oracleType = "NUMBER(10,0)", note = "积分任务加积分数-任务完成奖励")
    private Integer integralTaskReward;
}
