package com.biz.crm.integral.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.integral.model.SfaIntegralDetailEntity;
import com.biz.crm.integral.req.SfaIntegralDetailAddReq;
import com.biz.crm.nebular.mdm.PageVo;
import com.biz.crm.nebular.sfa.integral.req.*;
import com.biz.crm.nebular.sfa.integral.resp.SfaIntegralDetailRespVo;
import com.biz.crm.nebular.sfa.integral.resp.SfaIntegralRankRespVo;
import com.biz.crm.nebular.sfa.integral.resp.SfaIntegralUserRankRespVo;

/**
 * 积分明细
 * @author YuanZiJian
 * @date 2021/1/12 10:03
 * @version: V1.0
 */
public interface SfaIntegralDetailService  extends IService<SfaIntegralDetailEntity> {

    /**
     * 分页查询积分明细
     * @method pageIntegralDetail
     * @date: 2021/1/12 10:53
     * @author: YuanZiJian
     * @param sfaIntegralDetailReqVo
     * @return com.biz.crm.common.PageResult<com.biz.crm.nebular.sfa.integral.resp.SfaIntegralDetailRespVo>
     */
    PageResult<SfaIntegralDetailRespVo> integralDetailReport(SfaIntegralDetailReqVo sfaIntegralDetailReqVo);

    /**
     * 完成任务，获得积分
     *
     * @method req
     * @date: 2021/1/12 13:40
     * @author: YuanZiJian
     * @return void
     */
    void integralDetailAdd(SfaIntegralDetailAddReq req);

    /**
     * 分页查询积分排名——实现分页和模糊
     * @method pageIntegralRank
     * @date: 2021/1/12 16:09
     * @author: YuanZiJian
     * @param sfaIntegralRankReqVo
     * @return com.biz.crm.common.PageResult<com.biz.crm.nebular.sfa.integral.resp.SfaIntegralRankRespVo>
     */
    PageResult<SfaIntegralRankRespVo> pageIntegralRank(SfaIntegralRankReqVo sfaIntegralRankReqVo);

    /**
     * 查询个人的积分明细
     * @method pageDetailByLoginUser
     * @date: 2021/1/15 10:13
     * @author: YuanZiJian
     * @param sfaIntegralDetailUserReqVo 积分明细Vo 用于查询个人的积分明细
     * @return com.biz.crm.common.PageResult<com.biz.crm.nebular.sfa.integral.resp.SfaIntegralDetailRespVo>
     */
    PageResult<SfaIntegralDetailRespVo> pageDetailByLoginUser(SfaIntegralDetailUserReqVo sfaIntegralDetailUserReqVo);

    /**
     * 查询登陆用户的总积分 用于IntegralUserUtil 使用
     * 当userName为Null时则默认取登陆用户的userName
     * @method countIntegralNumByLoginUser
     * @date: 2021/1/15 10:15
     * @author: YuanZiJian
     * @return java.lang.Integer
     */
    SfaIntegralUserRankRespVo countIntegralNumByUserNameRedis(String userName);

    /**
     * 分页查询积分排名——实现分页和组织类型查询
     * @method pageIntegralRankToApp
     * @date: 2021/1/15 13:55
     * @author: YuanZiJian
     * @param orgType 查询组织类型
     * @return com.biz.crm.common.PageResult<com.biz.crm.nebular.sfa.integral.resp.SfaIntegralRankRespVo>
     */
    PageResult<SfaIntegralRankRespVo> pageIntegralRankToApp(SfaIntegralRankAppReqVo sfaIntegralRankAppReqVo);
}
